/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.Callable;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.tools.Version;
import picocli.CommandLine;

@CommandLine.Command(name="merge", header={"Merges multiple PDF documents into one"}, versionProvider=Version.class, mixinStandardHelpOptions=true)
public final class PDFMerger
implements Callable<Integer> {
    private static final PrintStream SYSERR = System.err;
    @CommandLine.Option(names={"-i", "--input"}, description={"the PDF files to merge."}, paramLabel="<infile>", required=true)
    private File[] infiles;
    @CommandLine.Option(names={"-o", "--output"}, description={"the merged PDF file."}, required=true)
    private File outfile;

    public static void main(String[] args) {
        System.setProperty("apple.awt.UIElement", "true");
        int exitCode = new CommandLine(new PDFMerger()).execute(args);
        System.exit(exitCode);
    }

    @Override
    public Integer call() {
        PDFMergerUtility merger = new PDFMergerUtility();
        try {
            for (File infile : this.infiles) {
                merger.addSource(infile);
            }
            merger.setDestinationFileName(this.outfile.getAbsolutePath());
            merger.mergeDocuments(IOUtils.createMemoryOnlyStreamCache());
        }
        catch (IOException ioe) {
            SYSERR.println("Error merging documents [" + ioe.getClass().getSimpleName() + "]: " + ioe.getMessage());
            return 4;
        }
        return 0;
    }
}

