/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.pdfparser.COSParser;
import org.apache.pdfbox.pdfparser.PDFObjectStreamParser;
import org.apache.pdfbox.pdfparser.XrefTrailerResolver;
import org.apache.pdfbox.pdmodel.encryption.ProtectionPolicy;
import org.apache.pdfbox.pdmodel.encryption.SecurityHandler;

public class BruteForceParser
extends COSParser {
    private static final char[] XREF_TABLE = new char[]{'x', 'r', 'e', 'f'};
    private static final char[] XREF_STREAM = new char[]{'/', 'X', 'R', 'e', 'f'};
    private static final long MINIMUM_SEARCH_OFFSET = 6L;
    private static final char[] EOF_MARKER = new char[]{'%', '%', 'E', 'O', 'F'};
    private static final char[] OBJ_MARKER = new char[]{'o', 'b', 'j'};
    private static final char[] TRAILER_MARKER = new char[]{'t', 'r', 'a', 'i', 'l', 'e', 'r'};
    private static final char[] OBJ_STREAM = new char[]{'/', 'O', 'b', 'j', 'S', 't', 'm'};
    private static final Log LOG = LogFactory.getLog(BruteForceParser.class);
    private final Map<COSObjectKey, Long> bfSearchCOSObjectKeyOffsets = new HashMap<COSObjectKey, Long>();
    private boolean bfSearchTriggered = false;

    public BruteForceParser(RandomAccessRead source, COSDocument document) throws IOException {
        super(source);
        this.document = document;
    }

    public boolean bfSearchTriggered() {
        return this.bfSearchTriggered;
    }

    protected Map<COSObjectKey, Long> getBFCOSObjectOffsets() throws IOException {
        if (!this.bfSearchTriggered) {
            this.bfSearchTriggered = true;
            this.bfSearchForObjects();
        }
        return this.bfSearchCOSObjectKeyOffsets;
    }

    private void bfSearchForObjects() throws IOException {
        long lastEOFMarker = this.bfSearchForLastEOFMarker();
        long originOffset = this.source.getPosition();
        long currentOffset = 6L;
        long lastObjectId = Long.MIN_VALUE;
        int lastGenID = Integer.MIN_VALUE;
        long lastObjOffset = Long.MIN_VALUE;
        char[] endobjString = "ndo".toCharArray();
        char[] endobjRemainingString = "bj".toCharArray();
        boolean endOfObjFound = false;
        do {
            this.source.seek(currentOffset);
            int nextChar = this.source.read();
            ++currentOffset;
            if (this.isWhitespace(nextChar) && this.isString(OBJ_MARKER)) {
                long tempOffset = currentOffset - 2L;
                this.source.seek(tempOffset);
                int genID = this.source.peek();
                if (!BruteForceParser.isDigit(genID)) continue;
                genID -= 48;
                this.source.seek(--tempOffset);
                if (!this.isWhitespace()) continue;
                while (tempOffset > 6L && this.isWhitespace()) {
                    this.source.seek(--tempOffset);
                }
                boolean objectIDFound = false;
                while (tempOffset > 6L && this.isDigit()) {
                    this.source.seek(--tempOffset);
                    objectIDFound = true;
                }
                if (!objectIDFound) continue;
                this.source.read();
                long objectId = this.readObjectNumber();
                if (lastObjOffset > 0L) {
                    this.bfSearchCOSObjectKeyOffsets.put(new COSObjectKey(lastObjectId, lastGenID), lastObjOffset);
                }
                lastObjectId = objectId;
                lastGenID = genID;
                lastObjOffset = tempOffset + 1L;
                currentOffset += (long)(OBJ_MARKER.length - 1);
                endOfObjFound = false;
                continue;
            }
            if (nextChar != 101 || !this.isString(endobjString)) continue;
            this.source.seek(currentOffset += (long)endobjString.length);
            if (this.source.isEOF()) {
                endOfObjFound = true;
                continue;
            }
            if (!this.isString(endobjRemainingString)) continue;
            currentOffset += (long)endobjRemainingString.length;
            endOfObjFound = true;
        } while (currentOffset < lastEOFMarker && !this.source.isEOF());
        if ((lastEOFMarker < Long.MAX_VALUE || endOfObjFound) && lastObjOffset > 0L) {
            this.bfSearchCOSObjectKeyOffsets.put(new COSObjectKey(lastObjectId, lastGenID), lastObjOffset);
        }
        this.source.seek(originOffset);
    }

    protected long bfSearchForXRef(long xrefOffset) throws IOException {
        long newOffset = -1L;
        List<Long> bfSearchXRefTablesOffsets = this.bfSearchForXRefTables();
        List<Long> bfSearchXRefStreamsOffsets = this.bfSearchForXRefStreams();
        long newOffsetTable = this.searchNearestValue(bfSearchXRefTablesOffsets, xrefOffset);
        long newOffsetStream = this.searchNearestValue(bfSearchXRefStreamsOffsets, xrefOffset);
        if (newOffsetTable > -1L && newOffsetStream > -1L) {
            long differenceTable = xrefOffset - newOffsetTable;
            long differenceStream = xrefOffset - newOffsetStream;
            if (Math.abs(differenceTable) > Math.abs(differenceStream)) {
                newOffset = newOffsetStream;
                bfSearchXRefStreamsOffsets.remove(newOffsetStream);
            } else {
                newOffset = newOffsetTable;
                bfSearchXRefTablesOffsets.remove(newOffsetTable);
            }
        } else if (newOffsetTable > -1L) {
            newOffset = newOffsetTable;
            bfSearchXRefTablesOffsets.remove(newOffsetTable);
        } else if (newOffsetStream > -1L) {
            newOffset = newOffsetStream;
            bfSearchXRefStreamsOffsets.remove(newOffsetStream);
        }
        return newOffset;
    }

    private long searchNearestValue(List<Long> values, long offset) {
        long newValue = -1L;
        Long currentDifference = null;
        int currentOffsetIndex = -1;
        int numberOfOffsets = values.size();
        for (int i = 0; i < numberOfOffsets; ++i) {
            long newDifference = offset - values.get(i);
            if (currentDifference != null && Math.abs(currentDifference) <= Math.abs(newDifference)) continue;
            currentDifference = newDifference;
            currentOffsetIndex = i;
        }
        if (currentOffsetIndex > -1) {
            newValue = values.get(currentOffsetIndex);
        }
        return newValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bfSearchForObjStreams(XrefTrailerResolver trailerResolver, SecurityHandler<? extends ProtectionPolicy> securityHandler) throws IOException {
        this.securityHandler = securityHandler;
        long originOffset = this.source.getPosition();
        Map<Long, COSObjectKey> bfSearchForObjStreamOffsets = this.bfSearchForObjStreamOffsets();
        Map<COSObjectKey, Long> bfCOSObjectOffsets = this.getBFCOSObjectOffsets();
        bfSearchForObjStreamOffsets.entrySet().stream().filter(o -> bfCOSObjectOffsets.get(o.getValue()) == null).forEach(o -> LOG.warn("Skipped incomplete object stream:" + o.getValue() + " at " + o.getKey()));
        List objStreamOffsets = bfSearchForObjStreamOffsets.entrySet().stream().filter(o -> bfCOSObjectOffsets.get(o.getValue()) != null).filter(o -> ((Long)o.getKey()).equals(bfCOSObjectOffsets.get(o.getValue()))).map(Map.Entry::getKey).collect(Collectors.toList());
        for (Long offset : objStreamOffsets) {
            this.source.seek(offset);
            long stmObjNumber = this.readObjectNumber();
            int stmGenNumber = this.readGenerationNumber();
            this.readExpectedString(OBJ_MARKER, true);
            COSStream stream = null;
            try {
                COSDictionary dict = this.parseCOSDictionary(false);
                stream = this.parseCOSStream(dict);
                if (securityHandler != null) {
                    securityHandler.decryptStream(stream, stmObjNumber, stmGenNumber);
                }
                PDFObjectStreamParser objStreamParser = new PDFObjectStreamParser(stream, this.document);
                Map<Long, Integer> objectNumbers = objStreamParser.readObjectNumbers();
                Map<COSObjectKey, Long> xrefOffset = trailerResolver.getXrefTable();
                for (Long objNumber : objectNumbers.keySet()) {
                    COSObjectKey objKey = new COSObjectKey(objNumber, 0);
                    Long existingOffset = bfCOSObjectOffsets.get(objKey);
                    if (existingOffset != null && existingOffset < 0L) {
                        COSObjectKey objStmKey = new COSObjectKey(Math.abs(existingOffset), 0);
                        existingOffset = bfCOSObjectOffsets.get(objStmKey);
                    }
                    if (existingOffset != null && offset <= existingOffset) continue;
                    bfCOSObjectOffsets.put(objKey, -stmObjNumber);
                    xrefOffset.put(objKey, -stmObjNumber);
                }
            }
            catch (IOException exception) {
                LOG.debug("Skipped corrupt stream: (" + stmObjNumber + " 0 at offset " + offset, exception);
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
        this.source.seek(originOffset);
    }

    private boolean bfSearchForTrailer(COSDictionary trailer) throws IOException {
        long originOffset = this.source.getPosition();
        this.source.seek(6L);
        long trailerOffset = this.findString(TRAILER_MARKER);
        while (trailerOffset != -1L) {
            try {
                COSBase infoDict;
                COSObject infoObj;
                COSBase rootDict;
                boolean rootFound = false;
                boolean infoFound = false;
                this.skipSpaces();
                COSDictionary trailerDict = this.parseCOSDictionary(true);
                COSObject rootObj = trailerDict.getCOSObject(COSName.ROOT);
                if (rootObj != null && (rootDict = rootObj.getObject()) instanceof COSDictionary && this.isCatalog((COSDictionary)rootDict)) {
                    rootFound = true;
                }
                if ((infoObj = trailerDict.getCOSObject(COSName.INFO)) != null && (infoDict = infoObj.getObject()) instanceof COSDictionary && this.isInfo((COSDictionary)infoDict)) {
                    infoFound = true;
                }
                if (rootFound && infoFound) {
                    COSBase idObj;
                    COSObject encObj;
                    trailer.setItem(COSName.ROOT, (COSBase)rootObj);
                    trailer.setItem(COSName.INFO, (COSBase)infoObj);
                    if (trailerDict.containsKey(COSName.ENCRYPT) && (encObj = trailerDict.getCOSObject(COSName.ENCRYPT)) != null && encObj.getObject() instanceof COSDictionary) {
                        trailer.setItem(COSName.ENCRYPT, (COSBase)encObj);
                    }
                    if (trailerDict.containsKey(COSName.ID) && (idObj = trailerDict.getItem(COSName.ID)) instanceof COSArray) {
                        trailer.setItem(COSName.ID, idObj);
                    }
                    return true;
                }
            }
            catch (IOException exception) {
                LOG.debug("An exception occurred during brute force search for trailer - ignoring", exception);
            }
            trailerOffset = this.findString(TRAILER_MARKER);
        }
        this.source.seek(originOffset);
        return false;
    }

    private boolean searchForTrailerItems(COSDictionary trailer) throws IOException {
        COSObject rootObject = null;
        COSObject infoObject = null;
        for (Map.Entry<COSObjectKey, Long> entrySet : this.getBFCOSObjectOffsets().entrySet()) {
            COSObjectKey currentKey = entrySet.getKey();
            COSObject cosObject = this.document.getObjectFromPool(currentKey);
            COSBase baseObject = cosObject.getObject();
            if (!(baseObject instanceof COSDictionary)) continue;
            COSDictionary dictionary = (COSDictionary)baseObject;
            if (this.isCatalog(dictionary)) {
                rootObject = this.compareCOSObjects(cosObject, entrySet.getValue(), rootObject);
                continue;
            }
            if (!this.isInfo(dictionary)) continue;
            infoObject = this.compareCOSObjects(cosObject, entrySet.getValue(), infoObject);
        }
        if (rootObject != null) {
            trailer.setItem(COSName.ROOT, rootObject);
        }
        if (infoObject != null) {
            trailer.setItem(COSName.INFO, infoObject);
        }
        return rootObject != null;
    }

    private COSObject compareCOSObjects(COSObject newObject, Long newOffset, COSObject currentObject) {
        if (currentObject != null && currentObject.getKey() != null) {
            COSObjectKey currentKey = currentObject.getKey();
            COSObjectKey newKey = newObject.getKey();
            if (currentKey.getNumber() == newKey.getNumber()) {
                return currentKey.getGeneration() < newKey.getGeneration() ? newObject : currentObject;
            }
            Long currentOffset = this.document.getXrefTable().get(currentKey);
            return currentOffset != null && newOffset > currentOffset ? newObject : currentObject;
        }
        return newObject;
    }

    private long bfSearchForLastEOFMarker() throws IOException {
        long lastEOFMarker = -1L;
        long originOffset = this.source.getPosition();
        this.source.seek(6L);
        long tempMarker = this.findString(EOF_MARKER);
        while (tempMarker != -1L) {
            try {
                this.skipSpaces();
                if (!this.isString(XREF_TABLE)) {
                    this.readObjectNumber();
                    this.readGenerationNumber();
                }
            }
            catch (IOException exception) {
                LOG.debug("An exception occurred during brute force for last EOF - ignoring", exception);
                lastEOFMarker = tempMarker;
            }
            tempMarker = this.findString(EOF_MARKER);
        }
        this.source.seek(originOffset);
        if (lastEOFMarker == -1L) {
            lastEOFMarker = Long.MAX_VALUE;
        }
        return lastEOFMarker;
    }

    private Map<Long, COSObjectKey> bfSearchForObjStreamOffsets() throws IOException {
        HashMap<Long, COSObjectKey> bfSearchObjStreamsOffsets = new HashMap<Long, COSObjectKey>();
        this.source.seek(6L);
        char[] string = " obj".toCharArray();
        long positionObjStream = this.findString(OBJ_STREAM);
        while (positionObjStream != -1L) {
            long newOffset = -1L;
            boolean objFound = false;
            block1: for (int i = 1; i < 40 && !objFound; ++i) {
                long currentOffset = positionObjStream - (long)(i * 10);
                if (currentOffset <= 0L) continue;
                this.source.seek(currentOffset);
                for (int j = 0; j < 10; ++j) {
                    if (this.isString(string)) {
                        long tempOffset = currentOffset - 1L;
                        this.source.seek(tempOffset);
                        int genID = this.source.peek();
                        if (BruteForceParser.isDigit(genID)) {
                            this.source.seek(--tempOffset);
                            if (this.isSpace()) {
                                int length = 0;
                                this.source.seek(--tempOffset);
                                while (tempOffset > 6L && this.isDigit()) {
                                    this.source.seek(--tempOffset);
                                    ++length;
                                }
                                if (length > 0) {
                                    this.source.read();
                                    newOffset = this.source.getPosition();
                                    long objNumber = this.readObjectNumber();
                                    int genNumber = this.readGenerationNumber();
                                    COSObjectKey streamObjectKey = new COSObjectKey(objNumber, genNumber);
                                    bfSearchObjStreamsOffsets.put(newOffset, streamObjectKey);
                                }
                            }
                        }
                        LOG.debug("Dictionary start for object stream -> " + newOffset);
                        objFound = true;
                        continue block1;
                    }
                    ++currentOffset;
                    this.source.read();
                }
            }
            this.source.seek(positionObjStream + (long)OBJ_STREAM.length);
            positionObjStream = this.findString(OBJ_STREAM);
        }
        return bfSearchObjStreamsOffsets;
    }

    private List<Long> bfSearchForXRefTables() throws IOException {
        ArrayList<Long> bfSearchXRefTablesOffsets = new ArrayList<Long>();
        this.source.seek(6L);
        long newOffset = this.findString(XREF_TABLE);
        while (newOffset != -1L) {
            this.source.seek(newOffset - 1L);
            if (this.isWhitespace()) {
                bfSearchXRefTablesOffsets.add(newOffset);
            }
            this.source.seek(newOffset + 4L);
            newOffset = this.findString(XREF_TABLE);
        }
        return bfSearchXRefTablesOffsets;
    }

    private List<Long> bfSearchForXRefStreams() throws IOException {
        ArrayList<Long> bfSearchXRefStreamsOffsets = new ArrayList<Long>();
        this.source.seek(6L);
        String objString = " obj";
        char[] string = objString.toCharArray();
        long xrefOffset = this.findString(XREF_STREAM);
        while (xrefOffset != -1L) {
            long newOffset = -1L;
            boolean objFound = false;
            block1: for (int i = 1; i < 40 && !objFound; ++i) {
                long currentOffset = xrefOffset - (long)(i * 10);
                if (currentOffset <= 0L) continue;
                this.source.seek(currentOffset);
                for (int j = 0; j < 10; ++j) {
                    if (this.isString(string)) {
                        long tempOffset = currentOffset - 1L;
                        this.source.seek(tempOffset);
                        int genID = this.source.peek();
                        if (BruteForceParser.isDigit(genID)) {
                            this.source.seek(--tempOffset);
                            if (this.isSpace()) {
                                int length = 0;
                                this.source.seek(--tempOffset);
                                while (tempOffset > 6L && this.isDigit()) {
                                    this.source.seek(--tempOffset);
                                    ++length;
                                }
                                if (length > 0) {
                                    this.source.read();
                                    newOffset = this.source.getPosition();
                                }
                            }
                        }
                        LOG.debug("Fixed reference for xref stream " + xrefOffset + " -> " + newOffset);
                        objFound = true;
                        continue block1;
                    }
                    ++currentOffset;
                    this.source.read();
                }
            }
            if (newOffset > -1L) {
                bfSearchXRefStreamsOffsets.add(newOffset);
            }
            this.source.seek(xrefOffset + 5L);
            xrefOffset = this.findString(XREF_STREAM);
        }
        return bfSearchXRefStreamsOffsets;
    }

    private boolean isInfo(COSDictionary dictionary) {
        if (dictionary.containsKey(COSName.PARENT) || dictionary.containsKey(COSName.A) || dictionary.containsKey(COSName.DEST)) {
            return false;
        }
        return dictionary.containsKey(COSName.MOD_DATE) || dictionary.containsKey(COSName.TITLE) || dictionary.containsKey(COSName.AUTHOR) || dictionary.containsKey(COSName.SUBJECT) || dictionary.containsKey(COSName.KEYWORDS) || dictionary.containsKey(COSName.CREATOR) || dictionary.containsKey(COSName.PRODUCER) || dictionary.containsKey(COSName.CREATION_DATE);
    }

    private boolean isCatalog(COSDictionary dictionary) {
        return COSName.CATALOG.equals(dictionary.getCOSName(COSName.TYPE)) || dictionary.containsKey(COSName.FDF);
    }

    private long findString(char[] string) throws IOException {
        long position = -1L;
        int stringLength = string.length;
        int counter = 0;
        int readChar = this.source.read();
        while (readChar != -1) {
            if (readChar == string[counter]) {
                if (counter == 0) {
                    position = this.source.getPosition() - 1L;
                }
                if (++counter == stringLength) {
                    return position;
                }
            } else if (counter > 0) {
                counter = 0;
                position = -1L;
                continue;
            }
            readChar = this.source.read();
        }
        return position;
    }

    protected COSDictionary rebuildTrailer(XrefTrailerResolver trailerResolver, SecurityHandler<? extends ProtectionPolicy> securityHandler) throws IOException {
        this.securityHandler = securityHandler;
        trailerResolver.reset();
        trailerResolver.nextXrefObj(0L, XrefTrailerResolver.XRefType.TABLE);
        this.getBFCOSObjectOffsets().forEach(trailerResolver::setXRef);
        trailerResolver.setStartxref(0L);
        COSDictionary trailer = trailerResolver.getTrailer();
        this.document.setTrailer(trailer);
        boolean searchForObjStreamsDone = false;
        if (!this.bfSearchForTrailer(trailer) && !this.searchForTrailerItems(trailer)) {
            this.bfSearchForObjStreams(trailerResolver, securityHandler);
            searchForObjStreamsDone = true;
            this.searchForTrailerItems(trailer);
        }
        this.prepareDecryption();
        if (!searchForObjStreamsDone) {
            this.bfSearchForObjStreams(trailerResolver, securityHandler);
        }
        return trailer;
    }
}

