/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.io.IOException;

public class DataInput {
    private final byte[] inputBuffer;
    private int bufferPosition = 0;

    public DataInput(byte[] buffer) {
        this.inputBuffer = buffer;
    }

    public boolean hasRemaining() {
        return this.bufferPosition < this.inputBuffer.length;
    }

    public int getPosition() {
        return this.bufferPosition;
    }

    public void setPosition(int position) throws IOException {
        if (position < 0) {
            throw new IOException("position is negative");
        }
        if (position >= this.inputBuffer.length) {
            throw new IOException("New position is out of range " + position + " >= " + this.inputBuffer.length);
        }
        this.bufferPosition = position;
    }

    public byte readByte() throws IOException {
        if (!this.hasRemaining()) {
            throw new IOException("End off buffer reached");
        }
        return this.inputBuffer[this.bufferPosition++];
    }

    public int readUnsignedByte() throws IOException {
        if (!this.hasRemaining()) {
            throw new IOException("End off buffer reached");
        }
        return this.inputBuffer[this.bufferPosition++] & 0xFF;
    }

    public int peekUnsignedByte(int offset) throws IOException {
        if (offset < 0) {
            throw new IOException("offset is negative");
        }
        if (this.bufferPosition + offset >= this.inputBuffer.length) {
            throw new IOException("Offset position is out of range " + (this.bufferPosition + offset) + " >= " + this.inputBuffer.length);
        }
        return this.inputBuffer[this.bufferPosition + offset] & 0xFF;
    }

    public short readShort() throws IOException {
        return (short)this.readUnsignedShort();
    }

    public int readUnsignedShort() throws IOException {
        int b1 = this.readUnsignedByte();
        int b2 = this.readUnsignedByte();
        return b1 << 8 | b2;
    }

    public int readInt() throws IOException {
        int b1 = this.readUnsignedByte();
        int b2 = this.readUnsignedByte();
        int b3 = this.readUnsignedByte();
        int b4 = this.readUnsignedByte();
        return b1 << 24 | b2 << 16 | b3 << 8 | b4;
    }

    public byte[] readBytes(int length) throws IOException {
        if (length < 0) {
            throw new IOException("length is negative");
        }
        if (this.inputBuffer.length - this.bufferPosition < length) {
            throw new IOException("Premature end of buffer reached");
        }
        byte[] bytes = new byte[length];
        System.arraycopy(this.inputBuffer, this.bufferPosition, bytes, 0, length);
        this.bufferPosition += length;
        return bytes;
    }

    public int length() {
        return this.inputBuffer.length;
    }
}

