/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.util.autodetect;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.fontbox.util.autodetect.FontDirFinder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class NativeFontDirFinder
implements FontDirFinder {
    private static final Logger LOG = LogManager.getLogger(NativeFontDirFinder.class);

    @Override
    public List<File> find() {
        ArrayList<File> fontDirList = new ArrayList<File>();
        String[] searchableDirectories = this.getSearchableDirectories();
        if (searchableDirectories != null) {
            for (String searchableDirectorie : searchableDirectories) {
                File fontDir = new File(searchableDirectorie);
                try {
                    if (!fontDir.exists() || !fontDir.canRead()) continue;
                    fontDirList.add(fontDir);
                }
                catch (SecurityException e) {
                    LOG.debug("Couldn't get native font directories - ignoring", (Throwable)e);
                }
            }
        }
        return fontDirList;
    }

    protected abstract String[] getSearchableDirectories();
}

