/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cmap;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fontbox.cmap.CIDRange;
import org.apache.fontbox.cmap.CMapStrings;
import org.apache.fontbox.cmap.CodespaceRange;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CMap {
    private static final Logger LOG = LogManager.getLogger(CMap.class);
    private int wmode = 0;
    private String cmapName = null;
    private String cmapVersion = null;
    private int cmapType = -1;
    private String registry = null;
    private String ordering = null;
    private int supplement = 0;
    private int minCodeLength = 4;
    private int maxCodeLength;
    private int minCidLength = 4;
    private int maxCidLength = 0;
    private final List<CodespaceRange> codespaceRanges = new ArrayList<CodespaceRange>();
    private final Map<Integer, String> charToUnicodeOneByte = new HashMap<Integer, String>();
    private final Map<Integer, String> charToUnicodeTwoBytes = new HashMap<Integer, String>();
    private final Map<Integer, String> charToUnicodeMoreBytes = new HashMap<Integer, String>();
    private final Map<Integer, Map<Integer, Integer>> codeToCid = new HashMap<Integer, Map<Integer, Integer>>();
    private final List<CIDRange> codeToCidRanges = new ArrayList<CIDRange>();
    private final Map<String, byte[]> unicodeToByteCodes = new HashMap<String, byte[]>();
    private static final String SPACE = " ";
    private int spaceMapping = -1;

    CMap() {
    }

    public boolean hasCIDMappings() {
        return !this.codeToCid.isEmpty() || !this.codeToCidRanges.isEmpty();
    }

    public boolean hasUnicodeMappings() {
        return !this.charToUnicodeOneByte.isEmpty() || !this.charToUnicodeTwoBytes.isEmpty() || !this.charToUnicodeMoreBytes.isEmpty();
    }

    public String toUnicode(int code) {
        String unicode;
        String string = unicode = code < 256 ? this.toUnicode(code, 1) : null;
        if (unicode == null) {
            if (code <= 65535) {
                return this.toUnicode(code, 2);
            }
            if (code <= 0xFFFFFF) {
                return this.toUnicode(code, 3);
            }
            return this.toUnicode(code, 4);
        }
        return unicode;
    }

    public String toUnicode(int code, int length) {
        if (length == 1) {
            return this.charToUnicodeOneByte.get(code);
        }
        if (length == 2) {
            return this.charToUnicodeTwoBytes.get(code);
        }
        return this.charToUnicodeMoreBytes.get(code);
    }

    public String toUnicode(byte[] code) {
        return this.toUnicode(CMap.toInt(code), code.length);
    }

    public int readCode(InputStream in) throws IOException {
        byte[] bytes = new byte[this.maxCodeLength];
        in.read(bytes, 0, this.minCodeLength);
        in.mark(this.maxCodeLength);
        for (int i = this.minCodeLength - 1; i < this.maxCodeLength; ++i) {
            int byteCount = i + 1;
            if (this.codespaceRanges.stream().anyMatch(r -> r.isFullMatch(bytes, byteCount))) {
                return CMap.toInt(bytes, byteCount);
            }
            if (byteCount >= this.maxCodeLength) continue;
            bytes[byteCount] = (byte)in.read();
        }
        if (LOG.isWarnEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.maxCodeLength; ++i) {
                sb.append(String.format("0x%02X (%04o) ", bytes[i], bytes[i]));
            }
            LOG.warn("Invalid character code sequence {} in CMap {}", (Object)sb, (Object)this.cmapName);
        }
        if (in.markSupported()) {
            in.reset();
        } else {
            LOG.warn("mark() and reset() not supported, {} bytes have been skipped", (Object)(this.maxCodeLength - 1));
        }
        return CMap.toInt(bytes, this.minCodeLength);
    }

    static int toInt(byte[] data) {
        return CMap.toInt(data, data.length);
    }

    private static int toInt(byte[] data, int dataLen) {
        int code = 0;
        for (int i = 0; i < dataLen; ++i) {
            code <<= 8;
            code |= data[i] & 0xFF;
        }
        return code;
    }

    public int toCID(byte[] code) {
        if (!this.hasCIDMappings() || code.length < this.minCidLength || code.length > this.maxCidLength) {
            return 0;
        }
        Integer cid = null;
        if (this.codeToCid.containsKey(code.length)) {
            cid = this.codeToCid.get(code.length).get(CMap.toInt(code));
        }
        if (cid == null) {
            cid = this.toCIDFromRanges(code);
        }
        return cid;
    }

    public int toCID(int code) {
        if (!this.hasCIDMappings()) {
            return 0;
        }
        int cid = 0;
        int length = this.minCidLength;
        while (cid == 0 && length <= this.maxCidLength) {
            cid = this.toCID(code, length++);
        }
        return cid;
    }

    public int toCID(int code, int length) {
        if (!this.hasCIDMappings() || length < this.minCidLength || length > this.maxCidLength) {
            return 0;
        }
        Integer cid = null;
        if (this.codeToCid.containsKey(length)) {
            cid = this.codeToCid.get(length).get(code);
        }
        return cid != null ? cid.intValue() : this.toCIDFromRanges(code, length);
    }

    private int toCIDFromRanges(int code, int length) {
        for (CIDRange range : this.codeToCidRanges) {
            int ch = range.map(code, length);
            if (ch == -1) continue;
            return ch;
        }
        return 0;
    }

    private int toCIDFromRanges(byte[] code) {
        for (CIDRange range : this.codeToCidRanges) {
            int ch = range.map(code);
            if (ch == -1) continue;
            return ch;
        }
        return 0;
    }

    void addCharMapping(byte[] codes, String unicode) {
        switch (codes.length) {
            case 1: {
                this.charToUnicodeOneByte.put(CMapStrings.getIndexValue(codes), unicode);
                this.unicodeToByteCodes.put(unicode, CMapStrings.getByteValue(codes));
                break;
            }
            case 2: {
                this.charToUnicodeTwoBytes.put(CMapStrings.getIndexValue(codes), unicode);
                this.unicodeToByteCodes.put(unicode, CMapStrings.getByteValue(codes));
                break;
            }
            case 3: 
            case 4: {
                this.charToUnicodeMoreBytes.put(CMap.toInt(codes), unicode);
                this.unicodeToByteCodes.put(unicode, (byte[])codes.clone());
                break;
            }
            default: {
                LOG.warn("Mappings with more than 4 bytes (here: {}) aren't supported yet", (Object)codes.length);
            }
        }
        if (SPACE.equals(unicode)) {
            this.spaceMapping = CMap.toInt(codes);
        }
    }

    public byte[] getCodesFromUnicode(String unicode) {
        return this.unicodeToByteCodes.get(unicode);
    }

    void addCIDMapping(byte[] code, int cid) {
        Map<Integer, Integer> codeToCidMap = this.codeToCid.get(code.length);
        if (codeToCidMap == null) {
            codeToCidMap = new HashMap<Integer, Integer>();
            this.codeToCid.put(code.length, codeToCidMap);
            this.minCidLength = Math.min(this.minCidLength, code.length);
            this.maxCidLength = Math.max(this.maxCidLength, code.length);
        }
        codeToCidMap.put(CMap.toInt(code), cid);
    }

    void addCIDRange(byte[] from, byte[] to, int cid) {
        this.addCIDRange(this.codeToCidRanges, CMap.toInt(from), CMap.toInt(to), cid, from.length);
    }

    private void addCIDRange(List<CIDRange> cidRanges, int from, int to, int cid, int length) {
        CIDRange lastRange = null;
        if (!cidRanges.isEmpty()) {
            lastRange = cidRanges.get(cidRanges.size() - 1);
        }
        if (lastRange == null || !lastRange.extend(from, to, cid, length)) {
            cidRanges.add(new CIDRange(from, to, cid, length));
            this.minCidLength = Math.min(this.minCidLength, length);
            this.maxCidLength = Math.max(this.maxCidLength, length);
        }
    }

    void addCodespaceRange(CodespaceRange range) {
        this.codespaceRanges.add(range);
        this.maxCodeLength = Math.max(this.maxCodeLength, range.getCodeLength());
        this.minCodeLength = Math.min(this.minCodeLength, range.getCodeLength());
    }

    void useCmap(CMap cmap) {
        cmap.codespaceRanges.forEach(this::addCodespaceRange);
        this.charToUnicodeOneByte.putAll(cmap.charToUnicodeOneByte);
        this.charToUnicodeTwoBytes.putAll(cmap.charToUnicodeTwoBytes);
        this.charToUnicodeMoreBytes.putAll(cmap.charToUnicodeMoreBytes);
        cmap.charToUnicodeOneByte.forEach((k, v) -> this.unicodeToByteCodes.put((String)v, new byte[]{(byte)(k % 255)}));
        cmap.charToUnicodeTwoBytes.forEach((k, v) -> this.unicodeToByteCodes.put((String)v, new byte[]{(byte)(k >>> 8 & 0xFF), (byte)(k & 0xFF)}));
        cmap.charToUnicodeMoreBytes.forEach((k, v) -> {
            byte[] bar = k <= 0xFFFFFF ? new byte[]{(byte)(k >>> 16 & 0xFF), (byte)(k >>> 8 & 0xFF), (byte)(k & 0xFF)} : new byte[]{(byte)(k >>> 24 & 0xFF), (byte)(k >>> 16 & 0xFF), (byte)(k >>> 8 & 0xFF), (byte)(k & 0xFF)};
            this.unicodeToByteCodes.put((String)v, bar);
        });
        cmap.codeToCid.forEach((key, value) -> {
            Map<Integer, Integer> existingMapping = this.codeToCid.putIfAbsent((Integer)key, (Map<Integer, Integer>)value);
            if (existingMapping != null) {
                existingMapping.putAll((Map<Integer, Integer>)value);
            }
        });
        this.codeToCidRanges.addAll(cmap.codeToCidRanges);
        this.maxCodeLength = Math.max(this.maxCodeLength, cmap.maxCodeLength);
        this.minCodeLength = Math.min(this.minCodeLength, cmap.minCodeLength);
        this.maxCidLength = Math.max(this.maxCidLength, cmap.maxCidLength);
        this.minCidLength = Math.min(this.minCidLength, cmap.minCidLength);
    }

    public int getWMode() {
        return this.wmode;
    }

    public void setWMode(int newWMode) {
        this.wmode = newWMode;
    }

    public String getName() {
        return this.cmapName;
    }

    public void setName(String name) {
        this.cmapName = name;
    }

    public String getVersion() {
        return this.cmapVersion;
    }

    public void setVersion(String version) {
        this.cmapVersion = version;
    }

    public int getType() {
        return this.cmapType;
    }

    public void setType(int type) {
        this.cmapType = type;
    }

    public String getRegistry() {
        return this.registry;
    }

    public void setRegistry(String newRegistry) {
        this.registry = newRegistry;
    }

    public String getOrdering() {
        return this.ordering;
    }

    public void setOrdering(String newOrdering) {
        this.ordering = newOrdering;
    }

    public int getSupplement() {
        return this.supplement;
    }

    public void setSupplement(int newSupplement) {
        this.supplement = newSupplement;
    }

    public int getSpaceMapping() {
        return this.spaceMapping;
    }

    public String toString() {
        return this.cmapName;
    }
}

