/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.fontbox.cff.CharStringCommand;
import org.apache.fontbox.cff.DataInput;
import org.apache.fontbox.cff.DataInputByteArray;

public class Type2CharStringParser {
    private static final int CALLSUBR = CharStringCommand.CALLSUBR.getValue();
    private static final int CALLGSUBR = CharStringCommand.CALLGSUBR.getValue();
    private static final int HINTMASK = CharStringCommand.HINTMASK.getValue();
    private static final int CNTRMASK = CharStringCommand.CNTRMASK.getValue();
    private final String fontName;

    public Type2CharStringParser(String fontName) {
        this.fontName = fontName;
    }

    public List<Object> parse(byte[] bytes, byte[][] globalSubrIndex, byte[][] localSubrIndex) throws IOException {
        GlyphData glyphData = new GlyphData();
        this.parseSequence(bytes, globalSubrIndex, localSubrIndex, glyphData);
        return glyphData.sequence;
    }

    private void parseSequence(byte[] bytes, byte[][] globalSubrIndex, byte[][] localSubrIndex, GlyphData glyphData) throws IOException {
        DataInputByteArray input = new DataInputByteArray(bytes);
        while (input.hasRemaining()) {
            int b0 = input.readUnsignedByte();
            if (b0 == CALLSUBR) {
                this.processCallSubr(globalSubrIndex, localSubrIndex, glyphData);
                continue;
            }
            if (b0 == CALLGSUBR) {
                this.processCallGSubr(globalSubrIndex, localSubrIndex, glyphData);
                continue;
            }
            if (b0 == HINTMASK || b0 == CNTRMASK) {
                glyphData.vstemCount += this.countNumbers(glyphData.sequence) / 2;
                int maskLength = this.getMaskLength(glyphData.hstemCount, glyphData.vstemCount);
                for (int i = 0; i < maskLength; ++i) {
                    input.readUnsignedByte();
                }
                glyphData.sequence.add((Object)CharStringCommand.getInstance(b0));
                continue;
            }
            if (b0 >= 0 && b0 <= 18 || b0 >= 21 && b0 <= 27 || b0 >= 29 && b0 <= 31) {
                glyphData.sequence.add((Object)this.readCommand(b0, input, glyphData));
                continue;
            }
            if (b0 == 28 || b0 >= 32 && b0 <= 255) {
                glyphData.sequence.add(this.readNumber(b0, input));
                continue;
            }
            throw new IllegalArgumentException();
        }
    }

    private byte[] getSubrBytes(byte[][] subrIndex, GlyphData glyphData) {
        int subrNumber = this.calculateSubrNumber((Integer)glyphData.sequence.remove(glyphData.sequence.size() - 1), subrIndex.length);
        return subrNumber < subrIndex.length ? subrIndex[subrNumber] : null;
    }

    private void processCallSubr(byte[][] globalSubrIndex, byte[][] localSubrIndex, GlyphData glyphData) throws IOException {
        if (localSubrIndex != null && localSubrIndex.length > 0) {
            byte[] subrBytes = this.getSubrBytes(localSubrIndex, glyphData);
            this.processSubr(globalSubrIndex, localSubrIndex, subrBytes, glyphData);
        }
    }

    private void processCallGSubr(byte[][] globalSubrIndex, byte[][] localSubrIndex, GlyphData glyphData) throws IOException {
        if (globalSubrIndex != null && globalSubrIndex.length > 0) {
            byte[] subrBytes = this.getSubrBytes(globalSubrIndex, glyphData);
            this.processSubr(globalSubrIndex, localSubrIndex, subrBytes, glyphData);
        }
    }

    private void processSubr(byte[][] globalSubrIndex, byte[][] localSubrIndex, byte[] subrBytes, GlyphData glyphData) throws IOException {
        this.parseSequence(subrBytes, globalSubrIndex, localSubrIndex, glyphData);
        Object lastItem = glyphData.sequence.get(glyphData.sequence.size() - 1);
        if (lastItem instanceof CharStringCommand && CharStringCommand.Type2KeyWord.RET == ((CharStringCommand)((Object)lastItem)).getType2KeyWord()) {
            glyphData.sequence.remove(glyphData.sequence.size() - 1);
        }
    }

    private int calculateSubrNumber(int operand, int subrIndexlength) {
        if (subrIndexlength < 1240) {
            return 107 + operand;
        }
        if (subrIndexlength < 33900) {
            return 1131 + operand;
        }
        return 32768 + operand;
    }

    private CharStringCommand readCommand(int b0, DataInput input, GlyphData glyphData) throws IOException {
        switch (b0) {
            case 1: 
            case 18: {
                glyphData.hstemCount += this.countNumbers(glyphData.sequence) / 2;
                return CharStringCommand.getInstance(b0);
            }
            case 3: 
            case 23: {
                glyphData.vstemCount += this.countNumbers(glyphData.sequence) / 2;
                return CharStringCommand.getInstance(b0);
            }
            case 12: {
                return CharStringCommand.getInstance(b0, input.readUnsignedByte());
            }
        }
        return CharStringCommand.getInstance(b0);
    }

    private Number readNumber(int b0, DataInput input) throws IOException {
        if (b0 == 28) {
            return (int)input.readShort();
        }
        if (b0 >= 32 && b0 <= 246) {
            return b0 - 139;
        }
        if (b0 >= 247 && b0 <= 250) {
            int b1 = input.readUnsignedByte();
            return (b0 - 247) * 256 + b1 + 108;
        }
        if (b0 >= 251 && b0 <= 254) {
            int b1 = input.readUnsignedByte();
            return -(b0 - 251) * 256 - b1 - 108;
        }
        if (b0 == 255) {
            short value = input.readShort();
            double fraction = (double)input.readUnsignedShort() / 65535.0;
            return (double)value + fraction;
        }
        throw new IllegalArgumentException();
    }

    private int getMaskLength(int hstemCount, int vstemCount) {
        int hintCount = hstemCount + vstemCount;
        int length = hintCount / 8;
        if (hintCount % 8 > 0) {
            ++length;
        }
        return length;
    }

    private int countNumbers(List<Object> sequence) {
        int count = 0;
        for (int i = sequence.size() - 1; i > -1; --i) {
            if (!(sequence.get(i) instanceof Number)) {
                return count;
            }
            ++count;
        }
        return count;
    }

    public String toString() {
        return this.fontName;
    }

    private class GlyphData {
        final List<Object> sequence = new ArrayList<Object>();
        int hstemCount = 0;
        int vstemCount = 0;

        private GlyphData() {
        }
    }
}

