/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.fontbox.EncodedFont;
import org.apache.fontbox.cff.CFFEncoding;
import org.apache.fontbox.cff.CFFFont;
import org.apache.fontbox.cff.Type1CharString;
import org.apache.fontbox.cff.Type2CharString;
import org.apache.fontbox.cff.Type2CharStringParser;
import org.apache.fontbox.type1.Type1CharStringReader;

public class CFFType1Font
extends CFFFont
implements EncodedFont {
    private final Map<String, Object> privateDict = new LinkedHashMap<String, Object>();
    private CFFEncoding encoding;
    private final Map<Integer, Type2CharString> charStringCache = new ConcurrentHashMap<Integer, Type2CharString>();
    private final PrivateType1CharStringReader reader = new PrivateType1CharStringReader();
    private Type2CharStringParser charStringParser = null;
    private int defaultWidthX = Integer.MIN_VALUE;
    private int nominalWidthX = Integer.MIN_VALUE;
    private byte[][] localSubrIndex;

    @Override
    public GeneralPath getPath(String name) throws IOException {
        return this.getType1CharString(name).getPath();
    }

    @Override
    public float getWidth(String name) throws IOException {
        return this.getType1CharString(name).getWidth();
    }

    @Override
    public boolean hasGlyph(String name) {
        int sid = this.getCharset().getSID(name);
        int gid = this.getCharset().getGIDForSID(sid);
        return gid != 0;
    }

    public Type1CharString getType1CharString(String name) throws IOException {
        int gid = this.nameToGID(name);
        return this.getType2CharString(gid, name);
    }

    public int nameToGID(String name) {
        int sid = this.getCharset().getSID(name);
        return this.getCharset().getGIDForSID(sid);
    }

    @Override
    public Type2CharString getType2CharString(int gid) throws IOException {
        String name = "GID+" + gid;
        return this.getType2CharString(gid, name);
    }

    private Type2CharString getType2CharString(int gid, String name) throws IOException {
        Type2CharString type2 = this.charStringCache.get(gid);
        if (type2 == null) {
            byte[] bytes = null;
            if (gid < this.charStrings.length) {
                bytes = this.charStrings[gid];
            }
            if (bytes == null) {
                bytes = this.charStrings[0];
            }
            List<Object> type2seq = this.getParser().parse(bytes, this.globalSubrIndex, this.getLocalSubrIndex());
            type2 = new Type2CharString(this.reader, this.getName(), name, gid, type2seq, this.getDefaultWidthX(), this.getNominalWidthX());
            this.charStringCache.put(gid, type2);
        }
        return type2;
    }

    private Type2CharStringParser getParser() {
        if (this.charStringParser == null) {
            this.charStringParser = new Type2CharStringParser(this.getName());
        }
        return this.charStringParser;
    }

    public Map<String, Object> getPrivateDict() {
        return this.privateDict;
    }

    void addToPrivateDict(String name, Object value) {
        if (value != null) {
            this.privateDict.put(name, value);
        }
    }

    @Override
    public CFFEncoding getEncoding() {
        return this.encoding;
    }

    void setEncoding(CFFEncoding encoding) {
        this.encoding = encoding;
    }

    private byte[][] getLocalSubrIndex() {
        if (this.localSubrIndex == null) {
            this.localSubrIndex = (byte[][])this.privateDict.get("Subrs");
        }
        return this.localSubrIndex;
    }

    private Object getProperty(String name) {
        Object topDictValue = this.topDict.get(name);
        if (topDictValue != null) {
            return topDictValue;
        }
        return this.privateDict.get(name);
    }

    private int getDefaultWidthX() {
        if (this.defaultWidthX == Integer.MIN_VALUE) {
            Number num = (Number)this.getProperty("defaultWidthX");
            this.defaultWidthX = num != null ? num.intValue() : 1000;
        }
        return this.defaultWidthX;
    }

    private int getNominalWidthX() {
        if (this.nominalWidthX == Integer.MIN_VALUE) {
            Number num = (Number)this.getProperty("nominalWidthX");
            this.nominalWidthX = num != null ? num.intValue() : 0;
        }
        return this.nominalWidthX;
    }

    private class PrivateType1CharStringReader
    implements Type1CharStringReader {
        private PrivateType1CharStringReader() {
        }

        @Override
        public Type1CharString getType1CharString(String name) throws IOException {
            return CFFType1Font.this.getType1CharString(name);
        }
    }
}

