/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf.model;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.fontbox.ttf.model.GsubData;
import org.apache.fontbox.ttf.model.Language;
import org.apache.fontbox.ttf.model.MapBackedScriptFeature;
import org.apache.fontbox.ttf.model.ScriptFeature;

public class MapBackedGsubData
implements GsubData {
    private final Language language;
    private final String activeScriptName;
    private final Map<String, Map<List<Integer>, List<Integer>>> glyphSubstitutionMap;

    public MapBackedGsubData(Language language, String activeScriptName, Map<String, Map<List<Integer>, List<Integer>>> glyphSubstitutionMap) {
        this.language = language;
        this.activeScriptName = activeScriptName;
        this.glyphSubstitutionMap = glyphSubstitutionMap;
    }

    @Override
    public Language getLanguage() {
        return this.language;
    }

    @Override
    public String getActiveScriptName() {
        return this.activeScriptName;
    }

    @Override
    public boolean isFeatureSupported(String featureName) {
        return this.glyphSubstitutionMap.containsKey(featureName);
    }

    @Override
    public ScriptFeature getFeature(String featureName) {
        if (!this.isFeatureSupported(featureName)) {
            throw new UnsupportedOperationException("The feature " + featureName + " is not supported!");
        }
        return new MapBackedScriptFeature(featureName, this.glyphSubstitutionMap.get(featureName));
    }

    @Override
    public Set<String> getSupportedFeatures() {
        return this.glyphSubstitutionMap.keySet();
    }
}

