/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf.gsub;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.fontbox.ttf.CmapLookup;
import org.apache.fontbox.ttf.gsub.GlyphArraySplitterRegexImpl;
import org.apache.fontbox.ttf.gsub.GsubWorker;
import org.apache.fontbox.ttf.model.GsubData;
import org.apache.fontbox.ttf.model.ScriptFeature;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GsubWorkerForLatin
implements GsubWorker {
    private static final Logger LOG = LogManager.getLogger(GsubWorkerForLatin.class);
    private static final List<String> FEATURES_IN_ORDER = Arrays.asList("ccmp", "liga", "clig");
    private final CmapLookup cmapLookup;
    private final GsubData gsubData;

    GsubWorkerForLatin(CmapLookup cmapLookup, GsubData gsubData) {
        this.cmapLookup = cmapLookup;
        this.gsubData = gsubData;
    }

    @Override
    public List<Integer> applyTransforms(List<Integer> originalGlyphIds) {
        List<Integer> intermediateGlyphsFromGsub = originalGlyphIds;
        for (String feature : FEATURES_IN_ORDER) {
            if (!this.gsubData.isFeatureSupported(feature)) {
                LOG.debug("the feature {} was not found", (Object)feature);
                continue;
            }
            LOG.debug("applying the feature {}", (Object)feature);
            ScriptFeature scriptFeature = this.gsubData.getFeature(feature);
            intermediateGlyphsFromGsub = this.applyGsubFeature(scriptFeature, intermediateGlyphsFromGsub);
        }
        return Collections.unmodifiableList(intermediateGlyphsFromGsub);
    }

    private List<Integer> applyGsubFeature(ScriptFeature scriptFeature, List<Integer> originalGlyphs) {
        if (scriptFeature.getAllGlyphIdsForSubstitution().isEmpty()) {
            LOG.debug("getAllGlyphIdsForSubstitution() for {} is empty", (Object)scriptFeature.getName());
            return originalGlyphs;
        }
        GlyphArraySplitterRegexImpl glyphArraySplitter = new GlyphArraySplitterRegexImpl(scriptFeature.getAllGlyphIdsForSubstitution());
        List<List<Integer>> tokens = glyphArraySplitter.split(originalGlyphs);
        ArrayList<Integer> gsubProcessedGlyphs = new ArrayList<Integer>();
        for (List<Integer> chunk : tokens) {
            if (scriptFeature.canReplaceGlyphs(chunk)) {
                List<Integer> replacementForGlyphs = scriptFeature.getReplacementForGlyphs(chunk);
                gsubProcessedGlyphs.addAll(replacementForGlyphs);
                continue;
            }
            gsubProcessedGlyphs.addAll(chunk);
        }
        LOG.debug("originalGlyphs: {}, gsubProcessedGlyphs: {}", originalGlyphs, gsubProcessedGlyphs);
        return gsubProcessedGlyphs;
    }
}

