/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import org.apache.fontbox.ttf.KerningSubtable;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KerningTable
extends TTFTable {
    private static final Logger LOG = LogManager.getLogger(KerningTable.class);
    public static final String TAG = "kern";
    private KerningSubtable[] subtables;

    KerningTable() {
    }

    @Override
    void read(TrueTypeFont ttf, TTFDataStream data) throws IOException {
        int version = data.readUnsignedShort();
        if (version != 0) {
            version = version << 16 | data.readUnsignedShort();
        }
        int numSubtables = 0;
        switch (version) {
            case 0: {
                numSubtables = data.readUnsignedShort();
                break;
            }
            case 1: {
                numSubtables = (int)data.readUnsignedInt();
                break;
            }
            default: {
                LOG.debug("Skipped kerning table due to an unsupported kerning table version: {}", (Object)version);
            }
        }
        if (numSubtables > 0) {
            this.subtables = new KerningSubtable[numSubtables];
            for (int i = 0; i < numSubtables; ++i) {
                KerningSubtable subtable = new KerningSubtable();
                subtable.read(data, version);
                this.subtables[i] = subtable;
            }
        }
        this.initialized = true;
    }

    public KerningSubtable getHorizontalKerningSubtable() {
        return this.getHorizontalKerningSubtable(false);
    }

    public KerningSubtable getHorizontalKerningSubtable(boolean cross) {
        if (this.subtables != null) {
            for (KerningSubtable s : this.subtables) {
                if (!s.isHorizontalKerning(cross)) continue;
                return s;
            }
        }
        return null;
    }
}

