/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.pfb;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PfbParser {
    private static final Logger LOG = LogManager.getLogger(PfbParser.class);
    private static final int PFB_HEADER_LENGTH = 18;
    private static final int START_MARKER = 128;
    private static final int ASCII_MARKER = 1;
    private static final int BINARY_MARKER = 2;
    private static final int EOF_MARKER = 3;
    private byte[] pfbdata;
    private final int[] lengths = new int[3];

    public PfbParser(String filename) throws IOException {
        this(Files.readAllBytes(Paths.get(filename, new String[0])));
    }

    public PfbParser(InputStream in) throws IOException {
        byte[] pfb = in.readAllBytes();
        this.parsePfb(pfb);
    }

    public PfbParser(byte[] bytes) throws IOException {
        this.parsePfb(bytes);
    }

    private void parsePfb(byte[] pfb) throws IOException {
        int i;
        byte[] ar;
        int total;
        int r;
        int size;
        if (pfb.length < 18) {
            throw new IOException("PFB header missing");
        }
        ArrayList<Integer> typeList = new ArrayList<Integer>(3);
        ArrayList<byte[]> barrList = new ArrayList<byte[]>(3);
        ByteArrayInputStream in = new ByteArrayInputStream(pfb);
        for (total = 0; (r = in.read()) != -1 || total <= 0; total += size) {
            if (r != 128) {
                throw new IOException("Start marker missing");
            }
            int recordType = in.read();
            if (recordType == 3) break;
            if (recordType != 1 && recordType != 2) {
                throw new IOException("Incorrect record type: " + recordType);
            }
            size = in.read();
            size += in.read() << 8;
            size += in.read() << 16;
            LOG.debug("record type: {}, segment size: {}", (Object)recordType, (Object)(size += in.read() << 24));
            ar = new byte[size];
            int got = in.read(ar);
            if (got != size) {
                throw new EOFException("EOF while reading PFB font");
            }
            typeList.add(recordType);
            barrList.add(ar);
        }
        this.pfbdata = new byte[total];
        byte[] cleartomarkSegment = null;
        int dstPos = 0;
        for (i = 0; i < typeList.size(); ++i) {
            if ((Integer)typeList.get(i) != 1) continue;
            ar = (byte[])barrList.get(i);
            if (i == typeList.size() - 1 && ar.length < 600 && new String(ar).contains("cleartomark")) {
                cleartomarkSegment = ar;
                continue;
            }
            System.arraycopy(ar, 0, this.pfbdata, dstPos, ar.length);
            dstPos += ar.length;
        }
        this.lengths[0] = dstPos;
        for (i = 0; i < typeList.size(); ++i) {
            if ((Integer)typeList.get(i) != 2) continue;
            ar = (byte[])barrList.get(i);
            System.arraycopy(ar, 0, this.pfbdata, dstPos, ar.length);
            dstPos += ar.length;
        }
        this.lengths[1] = dstPos - this.lengths[0];
        if (cleartomarkSegment != null) {
            System.arraycopy(cleartomarkSegment, 0, this.pfbdata, dstPos, cleartomarkSegment.length);
            this.lengths[2] = cleartomarkSegment.length;
        }
    }

    public int[] getLengths() {
        return this.lengths;
    }

    public byte[] getPfbdata() {
        return this.pfbdata;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.pfbdata);
    }

    public int size() {
        return this.pfbdata.length;
    }

    public byte[] getSegment1() {
        return Arrays.copyOfRange(this.pfbdata, 0, this.lengths[0]);
    }

    public byte[] getSegment2() {
        return Arrays.copyOfRange(this.pfbdata, this.lengths[0], this.lengths[0] + this.lengths[1]);
    }
}

