/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.fontbox.ttf.OTFParser;
import org.apache.fontbox.ttf.RandomAccessReadDataStream;
import org.apache.fontbox.ttf.TTCDataStream;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBuffer;
import org.apache.pdfbox.io.RandomAccessReadBufferedFile;

public class TrueTypeCollection
implements Closeable {
    private final TTFDataStream stream;
    private final int numFonts;
    private final long[] fontOffsets;

    public TrueTypeCollection(File file) throws IOException {
        this((RandomAccessRead)new RandomAccessReadBufferedFile(file));
    }

    public TrueTypeCollection(InputStream stream) throws IOException {
        this((RandomAccessRead)new RandomAccessReadBuffer(stream));
    }

    TrueTypeCollection(RandomAccessRead randomAccessRead) throws IOException {
        this.stream = new RandomAccessReadDataStream(randomAccessRead);
        String tag = this.stream.readTag();
        if (!tag.equals("ttcf")) {
            throw new IOException("Missing TTC header");
        }
        float version = this.stream.read32Fixed();
        this.numFonts = (int)this.stream.readUnsignedInt();
        if (this.numFonts <= 0 || this.numFonts > 1024) {
            throw new IOException("Invalid number of fonts " + this.numFonts);
        }
        this.fontOffsets = new long[this.numFonts];
        for (int i = 0; i < this.numFonts; ++i) {
            this.fontOffsets[i] = this.stream.readUnsignedInt();
        }
        if (version >= 2.0f) {
            int ulDsigTag = this.stream.readUnsignedShort();
            int ulDsigLength = this.stream.readUnsignedShort();
            int n = this.stream.readUnsignedShort();
        }
    }

    public void processAllFonts(TrueTypeFontProcessor trueTypeFontProcessor) throws IOException {
        for (int i = 0; i < this.numFonts; ++i) {
            TrueTypeFont font = this.getFontAtIndex(i);
            trueTypeFontProcessor.process(font);
        }
    }

    private TrueTypeFont getFontAtIndex(int idx) throws IOException {
        this.stream.seek(this.fontOffsets[idx]);
        TTFParser parser = this.stream.readTag().equals("OTTO") ? new OTFParser(false) : new TTFParser(false);
        this.stream.seek(this.fontOffsets[idx]);
        return parser.parse(new TTCDataStream(this.stream));
    }

    public TrueTypeFont getFontByName(String name) throws IOException {
        for (int i = 0; i < this.numFonts; ++i) {
            TrueTypeFont font = this.getFontAtIndex(i);
            if (!font.getName().equals(name)) continue;
            return font;
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @FunctionalInterface
    public static interface TrueTypeFontProcessor {
        public void process(TrueTypeFont var1) throws IOException;
    }
}

