/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.CmapTable;
import org.apache.fontbox.ttf.DigitalSignatureTable;
import org.apache.fontbox.ttf.GlyphSubstitutionTable;
import org.apache.fontbox.ttf.GlyphTable;
import org.apache.fontbox.ttf.HeaderTable;
import org.apache.fontbox.ttf.HorizontalHeaderTable;
import org.apache.fontbox.ttf.HorizontalMetricsTable;
import org.apache.fontbox.ttf.IndexToLocationTable;
import org.apache.fontbox.ttf.KerningTable;
import org.apache.fontbox.ttf.MaximumProfileTable;
import org.apache.fontbox.ttf.NamingTable;
import org.apache.fontbox.ttf.OS2WindowsMetricsTable;
import org.apache.fontbox.ttf.PostScriptTable;
import org.apache.fontbox.ttf.RandomAccessReadDataStream;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fontbox.ttf.VerticalHeaderTable;
import org.apache.fontbox.ttf.VerticalMetricsTable;
import org.apache.fontbox.ttf.VerticalOriginTable;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBuffer;

public class TTFParser {
    private static final Log LOG = LogFactory.getLog(TTFParser.class);
    private boolean isEmbedded = false;
    private boolean parseOnDemandOnly = false;

    public TTFParser() {
        this(false);
    }

    public TTFParser(boolean isEmbedded) {
        this(isEmbedded, false);
    }

    public TTFParser(boolean isEmbedded, boolean parseOnDemand) {
        this.isEmbedded = isEmbedded;
        this.parseOnDemandOnly = parseOnDemand;
    }

    public TrueTypeFont parse(RandomAccessRead randomAccessRead) throws IOException {
        RandomAccessReadDataStream dataStream = new RandomAccessReadDataStream(randomAccessRead);
        try {
            return this.parse(dataStream);
        }
        catch (IOException ex) {
            dataStream.close();
            throw ex;
        }
    }

    public TrueTypeFont parseEmbedded(InputStream inputStream) throws IOException {
        this.isEmbedded = true;
        return this.parse((RandomAccessRead)new RandomAccessReadBuffer(inputStream));
    }

    TrueTypeFont parse(TTFDataStream raf) throws IOException {
        TrueTypeFont font = this.newFont(raf);
        font.setVersion(raf.read32Fixed());
        int numberOfTables = raf.readUnsignedShort();
        int searchRange = raf.readUnsignedShort();
        int entrySelector = raf.readUnsignedShort();
        int rangeShift = raf.readUnsignedShort();
        for (int i = 0; i < numberOfTables; ++i) {
            TTFTable table = this.readTableDirectory(font, raf);
            if (table == null) continue;
            if (table.getOffset() + table.getLength() > font.getOriginalDataSize()) {
                LOG.warn((Object)("Skip table '" + table.getTag() + "' which goes past the file size; offset: " + table.getOffset() + ", size: " + table.getLength() + ", font size: " + font.getOriginalDataSize()));
                continue;
            }
            font.addTable(table);
        }
        if (!this.parseOnDemandOnly) {
            this.parseTables(font);
        }
        return font;
    }

    TrueTypeFont newFont(TTFDataStream raf) {
        return new TrueTypeFont(raf);
    }

    private void parseTables(TrueTypeFont font) throws IOException {
        for (TTFTable table : font.getTables()) {
            if (table.getInitialized()) continue;
            font.readTable(table);
        }
        boolean hasCFF = font.tables.containsKey("CFF ");
        boolean isPostScript = this.allowCFF() && hasCFF;
        HeaderTable head = font.getHeader();
        if (head == null) {
            throw new IOException("'head' table is mandatory");
        }
        HorizontalHeaderTable hh = font.getHorizontalHeader();
        if (hh == null) {
            throw new IOException("'hhea' table is mandatory");
        }
        MaximumProfileTable maxp = font.getMaximumProfile();
        if (maxp == null) {
            throw new IOException("'maxp' table is mandatory");
        }
        PostScriptTable post = font.getPostScript();
        if (post == null && !this.isEmbedded) {
            throw new IOException("'post' table is mandatory");
        }
        if (!isPostScript) {
            IndexToLocationTable loc;
            String messageSuffix = "";
            if (hasCFF) {
                messageSuffix = "; this an OpenType CFF font, but we expected a TrueType font here";
            }
            if ((loc = font.getIndexToLocation()) == null) {
                throw new IOException("'loca' table is mandatory" + messageSuffix);
            }
            if (font.getGlyph() == null) {
                throw new IOException("'glyf' table is mandatory" + messageSuffix);
            }
        }
        if (font.getNaming() == null && !this.isEmbedded) {
            throw new IOException("'name' table is mandatory");
        }
        if (font.getHorizontalMetrics() == null) {
            throw new IOException("'hmtx' table is mandatory");
        }
        if (!this.isEmbedded && font.getCmap() == null) {
            throw new IOException("'cmap' table is mandatory");
        }
    }

    protected boolean allowCFF() {
        return false;
    }

    private TTFTable readTableDirectory(TrueTypeFont font, TTFDataStream raf) throws IOException {
        TTFTable table;
        String tag;
        switch (tag = raf.readString(4)) {
            case "cmap": {
                table = new CmapTable();
                break;
            }
            case "glyf": {
                table = new GlyphTable();
                break;
            }
            case "head": {
                table = new HeaderTable();
                break;
            }
            case "hhea": {
                table = new HorizontalHeaderTable();
                break;
            }
            case "hmtx": {
                table = new HorizontalMetricsTable();
                break;
            }
            case "loca": {
                table = new IndexToLocationTable();
                break;
            }
            case "maxp": {
                table = new MaximumProfileTable();
                break;
            }
            case "name": {
                table = new NamingTable();
                break;
            }
            case "OS/2": {
                table = new OS2WindowsMetricsTable();
                break;
            }
            case "post": {
                table = new PostScriptTable();
                break;
            }
            case "DSIG": {
                table = new DigitalSignatureTable();
                break;
            }
            case "kern": {
                table = new KerningTable();
                break;
            }
            case "vhea": {
                table = new VerticalHeaderTable();
                break;
            }
            case "vmtx": {
                table = new VerticalMetricsTable();
                break;
            }
            case "VORG": {
                table = new VerticalOriginTable();
                break;
            }
            case "GSUB": {
                table = new GlyphSubstitutionTable();
                break;
            }
            default: {
                table = this.readTable(tag);
            }
        }
        table.setTag(tag);
        table.setCheckSum(raf.readUnsignedInt());
        table.setOffset(raf.readUnsignedInt());
        table.setLength(raf.readUnsignedInt());
        if (table.getLength() == 0L && !tag.equals("glyf")) {
            return null;
        }
        return table;
    }

    protected TTFTable readTable(String tag) {
        return new TTFTable();
    }
}

