/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.pdfbox.io.RandomAccessRead;

class RandomAccessReadDataStream
extends TTFDataStream {
    private final RandomAccessRead randomAccessRead;
    private final long length;
    private final byte[] data;

    RandomAccessReadDataStream(RandomAccessRead randomAccessRead) throws IOException {
        int amountRead;
        this.randomAccessRead = randomAccessRead;
        this.length = randomAccessRead.length();
        this.data = new byte[(int)this.length];
        int remainingBytes = this.data.length;
        while ((amountRead = randomAccessRead.read(this.data, this.data.length - remainingBytes, remainingBytes)) > 0) {
            remainingBytes -= amountRead;
        }
        randomAccessRead.seek(0L);
    }

    @Override
    public long getCurrentPosition() throws IOException {
        return this.randomAccessRead.getPosition();
    }

    @Override
    public void close() throws IOException {
        this.randomAccessRead.close();
    }

    @Override
    public int read() throws IOException {
        return this.randomAccessRead.read();
    }

    @Override
    public final long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    private int readInt() throws IOException {
        int b1 = this.read();
        int b2 = this.read();
        int b3 = this.read();
        int b4 = this.read();
        return (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
    }

    @Override
    public void seek(long pos) throws IOException {
        this.randomAccessRead.seek(pos);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.randomAccessRead.read(b, off, len);
    }

    @Override
    public InputStream getOriginalData() throws IOException {
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public long getOriginalDataSize() {
        return this.length;
    }
}

