/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.fontbox.cff.CharStringCommand;
import org.apache.fontbox.cff.DataInput;

public class Type2CharStringParser {
    private static final int CALLSUBR = 10;
    private static final int CALLGSUBR = 29;
    private int hstemCount;
    private int vstemCount;
    private List<Object> sequence;
    private final String fontName;
    private String currentGlyph;

    public Type2CharStringParser(String fontName) {
        this.fontName = fontName;
    }

    public List<Object> parse(byte[] bytes, byte[][] globalSubrIndex, byte[][] localSubrIndex, String glyphName) throws IOException {
        this.hstemCount = 0;
        this.vstemCount = 0;
        this.sequence = new ArrayList<Object>();
        this.currentGlyph = glyphName;
        return this.parseSequence(bytes, globalSubrIndex, localSubrIndex);
    }

    private List<Object> parseSequence(byte[] bytes, byte[][] globalSubrIndex, byte[][] localSubrIndex) throws IOException {
        boolean globalSubroutineIndexProvided;
        DataInput input = new DataInput(bytes);
        boolean localSubroutineIndexProvided = localSubrIndex != null && localSubrIndex.length > 0;
        boolean bl = globalSubroutineIndexProvided = globalSubrIndex != null && globalSubrIndex.length > 0;
        while (input.hasRemaining()) {
            int b0 = input.readUnsignedByte();
            if (b0 == 10 && localSubroutineIndexProvided) {
                this.processCallSubr(globalSubrIndex, localSubrIndex);
                continue;
            }
            if (b0 == 29 && globalSubroutineIndexProvided) {
                this.processCallGSubr(globalSubrIndex, localSubrIndex);
                continue;
            }
            if (b0 >= 0 && b0 <= 27 || b0 >= 29 && b0 <= 31) {
                this.sequence.add(this.readCommand(b0, input));
                continue;
            }
            if (b0 == 28 || b0 >= 32 && b0 <= 255) {
                this.sequence.add(this.readNumber(b0, input));
                continue;
            }
            throw new IllegalArgumentException();
        }
        return this.sequence;
    }

    private void processCallSubr(byte[][] globalSubrIndex, byte[][] localSubrIndex) throws IOException {
        int subrNumber = this.calculateSubrNumber((Integer)this.sequence.remove(this.sequence.size() - 1), localSubrIndex.length);
        if (subrNumber < localSubrIndex.length) {
            byte[] subrBytes = localSubrIndex[subrNumber];
            this.parseSequence(subrBytes, globalSubrIndex, localSubrIndex);
            Object lastItem = this.sequence.get(this.sequence.size() - 1);
            if (lastItem instanceof CharStringCommand && CharStringCommand.Type2KeyWord.RET == ((CharStringCommand)lastItem).getType2KeyWord()) {
                this.sequence.remove(this.sequence.size() - 1);
            }
        }
    }

    private void processCallGSubr(byte[][] globalSubrIndex, byte[][] localSubrIndex) throws IOException {
        int subrNumber = this.calculateSubrNumber((Integer)this.sequence.remove(this.sequence.size() - 1), globalSubrIndex.length);
        if (subrNumber < globalSubrIndex.length) {
            byte[] subrBytes = globalSubrIndex[subrNumber];
            this.parseSequence(subrBytes, globalSubrIndex, localSubrIndex);
            Object lastItem = this.sequence.get(this.sequence.size() - 1);
            if (lastItem instanceof CharStringCommand && CharStringCommand.Type2KeyWord.RET == ((CharStringCommand)lastItem).getType2KeyWord()) {
                this.sequence.remove(this.sequence.size() - 1);
            }
        }
    }

    private int calculateSubrNumber(int operand, int subrIndexlength) {
        if (subrIndexlength < 1240) {
            return 107 + operand;
        }
        if (subrIndexlength < 33900) {
            return 1131 + operand;
        }
        return 32768 + operand;
    }

    private CharStringCommand readCommand(int b0, DataInput input) throws IOException {
        if (b0 == 1 || b0 == 18) {
            this.hstemCount += this.countNumbers() / 2;
        } else if (b0 == 3 || b0 == 19 || b0 == 20 || b0 == 23) {
            this.vstemCount += this.countNumbers() / 2;
        }
        if (b0 == 12) {
            int b1 = input.readUnsignedByte();
            return CharStringCommand.getInstance(b0, b1);
        }
        if (b0 == 19 || b0 == 20) {
            int[] value = new int[1 + this.getMaskLength()];
            value[0] = b0;
            for (int i = 1; i < value.length; ++i) {
                value[i] = input.readUnsignedByte();
            }
            return CharStringCommand.getInstance(value);
        }
        return CharStringCommand.getInstance(b0);
    }

    private Number readNumber(int b0, DataInput input) throws IOException {
        if (b0 == 28) {
            return (int)input.readShort();
        }
        if (b0 >= 32 && b0 <= 246) {
            return b0 - 139;
        }
        if (b0 >= 247 && b0 <= 250) {
            int b1 = input.readUnsignedByte();
            return (b0 - 247) * 256 + b1 + 108;
        }
        if (b0 >= 251 && b0 <= 254) {
            int b1 = input.readUnsignedByte();
            return -(b0 - 251) * 256 - b1 - 108;
        }
        if (b0 == 255) {
            short value = input.readShort();
            double fraction = (double)input.readUnsignedShort() / 65535.0;
            return (double)value + fraction;
        }
        throw new IllegalArgumentException();
    }

    private int getMaskLength() {
        int hintCount = this.hstemCount + this.vstemCount;
        int length = hintCount / 8;
        if (hintCount % 8 > 0) {
            ++length;
        }
        return length;
    }

    private int countNumbers() {
        int count = 0;
        for (int i = this.sequence.size() - 1; i > -1; --i) {
            if (!(this.sequence.get(i) instanceof Number)) {
                return count;
            }
            ++count;
        }
        return count;
    }

    public String toString() {
        return this.fontName + ", current glpyh " + this.currentGlyph;
    }
}

