/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift.projection;

import java.util.LinkedList;
import java.util.List;
import org.apache.parquet.thrift.projection.FieldsPath;
import org.apache.parquet.thrift.projection.PathGlobPattern;

public class FieldProjectionFilter {
    public static final String PATTERN_SEPARATOR = ";";
    List<PathGlobPatternStatus> filterPatterns = new LinkedList<PathGlobPatternStatus>();

    public FieldProjectionFilter() {
    }

    public FieldProjectionFilter(String filterDescStr) {
        String[] rawPatterns;
        if (filterDescStr == null || filterDescStr.isEmpty()) {
            return;
        }
        for (String rawPattern : rawPatterns = filterDescStr.split(PATTERN_SEPARATOR)) {
            this.filterPatterns.add(new PathGlobPatternStatus(rawPattern));
        }
    }

    public boolean isMatched(FieldsPath path) {
        if (this.filterPatterns.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.filterPatterns.size(); ++i) {
            if (!this.filterPatterns.get(i).matches(path)) continue;
            return true;
        }
        return false;
    }

    public List<PathGlobPattern> getUnMatchedPatterns() {
        LinkedList<PathGlobPattern> unmatched = new LinkedList<PathGlobPattern>();
        for (PathGlobPatternStatus p : this.filterPatterns) {
            if (p.hasMatchingPath) continue;
            unmatched.add(p.pattern);
        }
        return unmatched;
    }

    private static class PathGlobPatternStatus {
        PathGlobPattern pattern;
        boolean hasMatchingPath = false;

        PathGlobPatternStatus(String pattern) {
            this.pattern = new PathGlobPattern(pattern);
        }

        public boolean matches(FieldsPath path) {
            if (this.pattern.matches(path.toString())) {
                this.hasMatchingPath = true;
                return true;
            }
            return false;
        }
    }
}

