/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift;

import com.twitter.elephantbird.thrift.TStructDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.thrift.ThriftSchemaConvertVisitor;
import org.apache.parquet.thrift.projection.FieldProjectionFilter;
import org.apache.parquet.thrift.projection.PathGlobPattern;
import org.apache.parquet.thrift.projection.ThriftProjectionException;
import org.apache.parquet.thrift.struct.ThriftField;
import org.apache.parquet.thrift.struct.ThriftType;
import org.apache.parquet.thrift.struct.ThriftTypeID;
import org.apache.thrift.TBase;
import org.apache.thrift.TEnum;
import org.apache.thrift.TUnion;

public class ThriftSchemaConverter {
    private final FieldProjectionFilter fieldProjectionFilter;

    public static <T extends TBase<?, ?>> ThriftType.StructType.StructOrUnionType structOrUnionType(Class<T> klass) {
        return TUnion.class.isAssignableFrom(klass) ? ThriftType.StructType.StructOrUnionType.UNION : ThriftType.StructType.StructOrUnionType.STRUCT;
    }

    public ThriftSchemaConverter() {
        this(new FieldProjectionFilter());
    }

    public ThriftSchemaConverter(FieldProjectionFilter fieldProjectionFilter) {
        this.fieldProjectionFilter = fieldProjectionFilter;
    }

    public MessageType convert(Class<? extends TBase<?, ?>> thriftClass) {
        return this.convert(new ThriftStructConverter().toStructType(thriftClass));
    }

    public MessageType convert(ThriftType.StructType thriftClass) {
        ThriftSchemaConvertVisitor visitor = new ThriftSchemaConvertVisitor(this.fieldProjectionFilter);
        thriftClass.accept(visitor);
        MessageType convertedMessageType = visitor.getConvertedMessageType();
        this.checkUnmatchedProjectionFilter(visitor.getFieldProjectionFilter());
        return convertedMessageType;
    }

    private void checkUnmatchedProjectionFilter(FieldProjectionFilter filter) {
        List<PathGlobPattern> unmatched = filter.getUnMatchedPatterns();
        if (unmatched.size() != 0) {
            throw new ThriftProjectionException("unmatched projection filters: " + unmatched.toString());
        }
    }

    public ThriftType.StructType toStructType(Class<? extends TBase<?, ?>> thriftClass) {
        return new ThriftStructConverter().toStructType(thriftClass);
    }

    private static class ThriftStructConverter {
        private ThriftStructConverter() {
        }

        public ThriftType.StructType toStructType(Class<? extends TBase<?, ?>> thriftClass) {
            TStructDescriptor struct = TStructDescriptor.getInstance(thriftClass);
            return this.toStructType(struct);
        }

        private ThriftType.StructType toStructType(TStructDescriptor struct) {
            List fields = struct.getFields();
            ArrayList<ThriftField> children = new ArrayList<ThriftField>(fields.size());
            for (int i = 0; i < fields.size(); ++i) {
                TStructDescriptor.Field field = (TStructDescriptor.Field)fields.get(i);
                ThriftField.Requirement req = field.getFieldMetaData() == null ? ThriftField.Requirement.OPTIONAL : ThriftField.Requirement.fromType(field.getFieldMetaData().requirementType);
                children.add(this.toThriftField(field.getName(), field, req));
            }
            return new ThriftType.StructType(children, ThriftSchemaConverter.structOrUnionType(struct.getThriftClass()));
        }

        private ThriftField toThriftField(String name, TStructDescriptor.Field field, ThriftField.Requirement requirement) {
            ThriftType type;
            switch (ThriftTypeID.fromByte(field.getType())) {
                default: {
                    throw new UnsupportedOperationException("can't convert type of " + field);
                }
                case BOOL: {
                    type = new ThriftType.BoolType();
                    break;
                }
                case BYTE: {
                    type = new ThriftType.ByteType();
                    break;
                }
                case DOUBLE: {
                    type = new ThriftType.DoubleType();
                    break;
                }
                case I16: {
                    type = new ThriftType.I16Type();
                    break;
                }
                case I32: {
                    type = new ThriftType.I32Type();
                    break;
                }
                case I64: {
                    type = new ThriftType.I64Type();
                    break;
                }
                case STRING: {
                    type = new ThriftType.StringType();
                    break;
                }
                case STRUCT: {
                    type = this.toStructType(field.gettStructDescriptor());
                    break;
                }
                case MAP: {
                    TStructDescriptor.Field mapKeyField = field.getMapKeyField();
                    TStructDescriptor.Field mapValueField = field.getMapValueField();
                    type = new ThriftType.MapType(this.toThriftField(mapKeyField.getName(), mapKeyField, requirement), this.toThriftField(mapValueField.getName(), mapValueField, requirement));
                    break;
                }
                case SET: {
                    TStructDescriptor.Field setElemField = field.getSetElemField();
                    type = new ThriftType.SetType(this.toThriftField(name, setElemField, requirement));
                    break;
                }
                case LIST: {
                    TStructDescriptor.Field listElemField = field.getListElemField();
                    type = new ThriftType.ListType(this.toThriftField(name, listElemField, requirement));
                    break;
                }
                case ENUM: {
                    Collection enumValues = field.getEnumValues();
                    ArrayList<ThriftType.EnumValue> values = new ArrayList<ThriftType.EnumValue>();
                    for (TEnum tEnum : enumValues) {
                        values.add(new ThriftType.EnumValue(tEnum.getValue(), tEnum.toString()));
                    }
                    type = new ThriftType.EnumType(values);
                }
            }
            return new ThriftField(name, field.getId(), requirement, type);
        }
    }
}

