/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import org.apache.parquet.Log;
import org.apache.parquet.thrift.ParquetProtocol;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.protocol.TStruct;

class ParquetReadProtocol
extends ParquetProtocol {
    private static final Log LOG = Log.getLog(ParquetReadProtocol.class);
    private Deque<TProtocol> events = new LinkedList<TProtocol>();

    ParquetReadProtocol() {
        super("read");
    }

    public void add(TProtocol p) {
        this.events.addLast(p);
    }

    public void addAll(Collection<TProtocol> events) {
        this.events.addAll(events);
    }

    private TProtocol next() {
        return this.events.removeFirst();
    }

    @Override
    public TMessage readMessageBegin() throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)"readMessageBegin()");
        }
        return this.next().readMessageBegin();
    }

    @Override
    public void readMessageEnd() throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)"readMessageEnd()");
        }
        this.next().readMessageEnd();
    }

    @Override
    public TStruct readStructBegin() throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)"readStructBegin()");
        }
        return this.next().readStructBegin();
    }

    @Override
    public void readStructEnd() throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)"readStructEnd()");
        }
        this.next().readStructEnd();
    }

    @Override
    public TField readFieldBegin() throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)"readFieldBegin()");
        }
        return this.next().readFieldBegin();
    }

    @Override
    public void readFieldEnd() throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)"readFieldEnd()");
        }
        this.next().readFieldEnd();
    }

    @Override
    public TMap readMapBegin() throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)"readMapBegin()");
        }
        return this.next().readMapBegin();
    }

    @Override
    public void readMapEnd() throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)"readMapEnd()");
        }
        this.next().readMapEnd();
    }

    @Override
    public TList readListBegin() throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)"readListBegin()");
        }
        return this.next().readListBegin();
    }

    @Override
    public void readListEnd() throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)"readListEnd()");
        }
        this.next().readListEnd();
    }

    @Override
    public TSet readSetBegin() throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)"readSetBegin()");
        }
        return this.next().readSetBegin();
    }

    @Override
    public void readSetEnd() throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)"readSetEnd()");
        }
        this.next().readSetEnd();
    }

    @Override
    public boolean readBool() throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)"readBool()");
        }
        return this.next().readBool();
    }

    @Override
    public byte readByte() throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)"readByte()");
        }
        return this.next().readByte();
    }

    @Override
    public short readI16() throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)"readI16()");
        }
        return this.next().readI16();
    }

    @Override
    public int readI32() throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)"readI32()");
        }
        return this.next().readI32();
    }

    @Override
    public long readI64() throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)"readI64()");
        }
        return this.next().readI64();
    }

    @Override
    public double readDouble() throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)"readDouble()");
        }
        return this.next().readDouble();
    }

    @Override
    public String readString() throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)"readString()");
        }
        return this.next().readString();
    }

    @Override
    public ByteBuffer readBinary() throws TException {
        if (Log.DEBUG) {
            LOG.debug((Object)"readBinary()");
        }
        return this.next().readBinary();
    }
}

