/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.thrift;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.parquet.hadoop.thrift.ParquetThriftBytesOutputFormat;
import org.apache.parquet.thrift.FieldIgnoredHandler;
import org.apache.thrift.TBase;
import org.apache.thrift.protocol.TProtocolFactory;

public class ThriftToParquetFileWriter
implements Closeable {
    private final RecordWriter<Void, BytesWritable> recordWriter;
    private final TaskAttemptContext taskAttemptContext;

    public ThriftToParquetFileWriter(Path fileToCreate, TaskAttemptContext taskAttemptContext, TProtocolFactory protocolFactory, Class<? extends TBase<?, ?>> thriftClass) throws IOException, InterruptedException {
        this(fileToCreate, taskAttemptContext, protocolFactory, thriftClass, true, null);
    }

    public ThriftToParquetFileWriter(Path fileToCreate, TaskAttemptContext taskAttemptContext, TProtocolFactory protocolFactory, Class<? extends TBase<?, ?>> thriftClass, FieldIgnoredHandler errorHandler) throws IOException, InterruptedException {
        this(fileToCreate, taskAttemptContext, protocolFactory, thriftClass, true, errorHandler);
    }

    public ThriftToParquetFileWriter(Path fileToCreate, TaskAttemptContext taskAttemptContext, TProtocolFactory protocolFactory, Class<? extends TBase<?, ?>> thriftClass, boolean buffered, FieldIgnoredHandler errorHandler) throws IOException, InterruptedException {
        this.taskAttemptContext = taskAttemptContext;
        this.recordWriter = new ParquetThriftBytesOutputFormat(protocolFactory, thriftClass, buffered, errorHandler).getRecordWriter(taskAttemptContext, fileToCreate);
    }

    public void write(BytesWritable bytes) throws IOException, InterruptedException {
        this.recordWriter.write(null, (Object)bytes);
    }

    @Override
    public void close() throws IOException {
        try {
            this.recordWriter.close(this.taskAttemptContext);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new IOException("The thread was interrupted", e);
        }
    }
}

