/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.thrift;

import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.parquet.Log;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.thrift.TBaseRecordConverter;
import org.apache.parquet.thrift.ThriftMetaData;
import org.apache.parquet.thrift.ThriftRecordConverter;
import org.apache.parquet.thrift.ThriftSchemaConverter;
import org.apache.parquet.thrift.projection.FieldProjectionFilter;
import org.apache.parquet.thrift.projection.ThriftProjectionException;
import org.apache.parquet.thrift.struct.ThriftType;

public class ThriftReadSupport<T>
extends ReadSupport<T> {
    private static final Log LOG = Log.getLog(ThriftReadSupport.class);
    public static final String THRIFT_COLUMN_FILTER_KEY = "parquet.thrift.column.filter";
    private static final String RECORD_CONVERTER_DEFAULT = TBaseRecordConverter.class.getName();
    public static final String THRIFT_READ_CLASS_KEY = "parquet.thrift.read.class";
    private static final String RECORD_CONVERTER_CLASS_KEY = "parquet.thrift.converter.class";
    protected Class<T> thriftClass;

    public static void setRecordConverterClass(JobConf conf, Class<?> klass) {
        conf.set(RECORD_CONVERTER_CLASS_KEY, klass.getName());
    }

    public ThriftReadSupport() {
    }

    public ThriftReadSupport(Class<T> thriftClass) {
        this.thriftClass = thriftClass;
    }

    public ReadSupport.ReadContext init(InitContext context) {
        MessageType fileMessageType;
        Configuration configuration = context.getConfiguration();
        MessageType requestedProjection = fileMessageType = context.getFileSchema();
        String partialSchemaString = configuration.get("parquet.read.schema");
        String projectionFilterString = configuration.get(THRIFT_COLUMN_FILTER_KEY);
        if (partialSchemaString != null && projectionFilterString != null) {
            throw new ThriftProjectionException("PARQUET_READ_SCHEMA and THRIFT_COLUMN_FILTER_KEY are both specified, should use only one.");
        }
        if (partialSchemaString != null) {
            requestedProjection = ThriftReadSupport.getSchemaForRead((MessageType)fileMessageType, (String)partialSchemaString);
        } else if (projectionFilterString != null && !projectionFilterString.isEmpty()) {
            FieldProjectionFilter fieldProjectionFilter = new FieldProjectionFilter(projectionFilterString);
            try {
                this.initThriftClassFromMultipleFiles(context.getKeyValueMetadata(), configuration);
                requestedProjection = this.getProjectedSchema(fieldProjectionFilter);
            }
            catch (ClassNotFoundException e) {
                throw new ThriftProjectionException("can not find thriftClass from configuration");
            }
        }
        MessageType schemaForRead = ThriftReadSupport.getSchemaForRead((MessageType)fileMessageType, (MessageType)requestedProjection);
        return new ReadSupport.ReadContext(schemaForRead);
    }

    protected MessageType getProjectedSchema(FieldProjectionFilter fieldProjectionFilter) {
        return new ThriftSchemaConverter(fieldProjectionFilter).convert(this.thriftClass);
    }

    private void initThriftClassFromMultipleFiles(Map<String, Set<String>> fileMetadata, Configuration conf) throws ClassNotFoundException {
        if (this.thriftClass != null) {
            return;
        }
        String className = conf.get(THRIFT_READ_CLASS_KEY, null);
        if (className == null) {
            Set<String> names = ThriftMetaData.getThriftClassNames(fileMetadata);
            if (names == null || names.size() != 1) {
                throw new ParquetDecodingException("Could not read file as the Thrift class is not provided and could not be resolved from the file: " + names);
            }
            className = names.iterator().next();
        }
        this.thriftClass = Class.forName(className);
    }

    private void initThriftClass(Map<String, String> fileMetadata, Configuration conf) throws ClassNotFoundException {
        if (this.thriftClass != null) {
            return;
        }
        String className = conf.get(THRIFT_READ_CLASS_KEY, null);
        if (className == null) {
            ThriftMetaData metaData = ThriftMetaData.fromExtraMetaData(fileMetadata);
            if (metaData == null) {
                throw new ParquetDecodingException("Could not read file as the Thrift class is not provided and could not be resolved from the file");
            }
            this.thriftClass = metaData.getThriftClass();
        } else {
            this.thriftClass = Class.forName(className);
        }
    }

    public RecordMaterializer<T> prepareForRead(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        ThriftMetaData thriftMetaData = ThriftMetaData.fromExtraMetaData(keyValueMetaData);
        try {
            this.initThriftClass(keyValueMetaData, configuration);
            String converterClassName = configuration.get(RECORD_CONVERTER_CLASS_KEY, RECORD_CONVERTER_DEFAULT);
            Class<?> converterClass = Class.forName(converterClassName);
            Constructor<?> constructor = converterClass.getConstructor(Class.class, MessageType.class, ThriftType.StructType.class);
            ThriftRecordConverter converter = (ThriftRecordConverter)((Object)constructor.newInstance(this.thriftClass, readContext.getRequestedSchema(), thriftMetaData.getDescriptor()));
            return converter;
        }
        catch (Exception t) {
            throw new RuntimeException("Unable to create Thrift Converter for Thrift metadata " + thriftMetaData, t);
        }
    }

    public static void setProjectionPushdown(JobConf jobConf, String projectionString) {
        jobConf.set(THRIFT_COLUMN_FILTER_KEY, projectionString);
    }
}

