/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.thrift;

import com.twitter.elephantbird.pig.util.ThriftToPig;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.Log;
import org.apache.parquet.hadoop.BadConfigurationException;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.pig.PigMetaData;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.thrift.ParquetWriteProtocol;
import org.apache.parquet.thrift.ThriftMetaData;
import org.apache.parquet.thrift.ThriftSchemaConverter;
import org.apache.parquet.thrift.struct.ThriftType;
import org.apache.thrift.TBase;

public abstract class AbstractThriftWriteSupport<T>
extends WriteSupport<T> {
    public static final String PARQUET_THRIFT_CLASS = "parquet.thrift.class";
    private static final Log LOG = Log.getLog(AbstractThriftWriteSupport.class);
    protected Class<T> thriftClass;
    protected MessageType schema;
    protected ThriftType.StructType thriftStruct;
    protected ParquetWriteProtocol parquetWriteProtocol;
    protected WriteSupport.WriteContext writeContext;

    public static void setGenericThriftClass(Configuration configuration, Class<?> thriftClass) {
        configuration.set(PARQUET_THRIFT_CLASS, thriftClass.getName());
    }

    public static Class getGenericThriftClass(Configuration configuration) {
        String thriftClassName = configuration.get(PARQUET_THRIFT_CLASS);
        if (thriftClassName == null) {
            throw new BadConfigurationException("the thrift class conf is missing in job conf at parquet.thrift.class");
        }
        try {
            Class<?> thriftClass = Class.forName(thriftClassName);
            return thriftClass;
        }
        catch (ClassNotFoundException e) {
            throw new BadConfigurationException("the class " + thriftClassName + " in job conf at " + PARQUET_THRIFT_CLASS + " could not be found", (Throwable)e);
        }
    }

    public AbstractThriftWriteSupport() {
    }

    public AbstractThriftWriteSupport(Class<T> thriftClass) {
        this.init(thriftClass);
    }

    protected void init(Class<T> thriftClass) {
        this.thriftClass = thriftClass;
        this.thriftStruct = this.getThriftStruct();
        ThriftSchemaConverter thriftSchemaConverter = new ThriftSchemaConverter();
        this.schema = thriftSchemaConverter.convert(this.thriftStruct);
        Map<String, String> extraMetaData = new ThriftMetaData(thriftClass.getName(), this.thriftStruct).toExtraMetaData();
        if (this.isPigLoaded() && TBase.class.isAssignableFrom(thriftClass)) {
            new PigMetaData(new ThriftToPig(thriftClass).toSchema()).addToMetaData(extraMetaData);
        }
        this.writeContext = new WriteSupport.WriteContext(this.schema, extraMetaData);
    }

    protected boolean isPigLoaded() {
        try {
            Class.forName("org.apache.pig.impl.logicalLayer.schema.Schema");
            return true;
        }
        catch (ClassNotFoundException e) {
            LOG.info((Object)"Pig is not loaded, pig metadata will not be written");
            return false;
        }
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        if (this.writeContext == null) {
            this.init(AbstractThriftWriteSupport.getGenericThriftClass(configuration));
        }
        return this.writeContext;
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        MessageColumnIO columnIO = new ColumnIOFactory().getColumnIO(this.schema);
        this.parquetWriteProtocol = new ParquetWriteProtocol(recordConsumer, columnIO, this.thriftStruct);
    }

    protected abstract ThriftType.StructType getThriftStruct();
}

