/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift.struct;

import org.apache.parquet.thrift.struct.ThriftType;

public enum ThriftTypeID {
    STOP(0),
    VOID(1),
    BOOL(2, ThriftType.BoolType.class),
    BYTE(3, ThriftType.ByteType.class),
    DOUBLE(4, ThriftType.DoubleType.class),
    I16(6, ThriftType.I16Type.class),
    I32(8, ThriftType.I32Type.class),
    I64(10, ThriftType.I64Type.class),
    STRING(11, ThriftType.StringType.class),
    STRUCT(12, true, ThriftType.StructType.class),
    MAP(13, true, ThriftType.MapType.class),
    SET(14, true, ThriftType.SetType.class),
    LIST(15, true, ThriftType.ListType.class),
    ENUM(-1, 8, ThriftType.EnumType.class),
    UUID(16, ThriftType.UUIDType.class);

    private static final ThriftTypeID[] types;
    private final byte thriftType;
    private final boolean complex;
    private final Class<? extends ThriftType> clss;
    private final byte serializedThriftType;

    private ThriftTypeID(byte thriftType, Class<? extends ThriftType> clss) {
        this(thriftType, thriftType, clss);
    }

    private ThriftTypeID(byte thriftType, byte serializedThriftType, Class<? extends ThriftType> clss) {
        this(thriftType, serializedThriftType, false, clss);
    }

    private ThriftTypeID(byte thriftType) {
        this(thriftType, thriftType, false, null);
    }

    private ThriftTypeID(byte thriftType, boolean complex, Class<? extends ThriftType> clss) {
        this(thriftType, thriftType, complex, clss);
    }

    private ThriftTypeID(byte thriftType, byte serializedThriftType, boolean complex, Class<? extends ThriftType> clss) {
        this.thriftType = thriftType;
        this.serializedThriftType = serializedThriftType;
        this.complex = complex;
        this.clss = clss;
    }

    public byte getThriftType() {
        return this.thriftType;
    }

    public boolean isComplex() {
        return this.complex;
    }

    public Class<? extends ThriftType> getType() {
        return this.clss;
    }

    public static ThriftTypeID fromByte(byte type) {
        return types[type];
    }

    public byte getSerializedThriftType() {
        return this.serializedThriftType;
    }

    static {
        types = new ThriftTypeID[18];
        for (ThriftTypeID t : ThriftTypeID.values()) {
            if (t.thriftType == -1) {
                ThriftTypeID.types[17] = t;
                continue;
            }
            ThriftTypeID.types[t.thriftType] = t;
        }
    }
}

