/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift.projection.deprecated;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.parquet.thrift.projection.FieldProjectionFilter;
import org.apache.parquet.thrift.projection.FieldsPath;
import org.apache.parquet.thrift.projection.ThriftProjectionException;
import org.apache.parquet.thrift.projection.deprecated.PathGlobPattern;

@Deprecated
public class DeprecatedFieldProjectionFilter
implements FieldProjectionFilter {
    public static final String PATTERN_SEPARATOR = ";";
    private final List<PathGlobPatternStatus> filterPatterns;

    public DeprecatedFieldProjectionFilter(String filterDescStr) {
        String[] rawPatterns;
        Objects.requireNonNull(filterDescStr, "filterDescStr cannot be null");
        this.filterPatterns = new LinkedList<PathGlobPatternStatus>();
        if (filterDescStr == null || filterDescStr.isEmpty()) {
            return;
        }
        for (String rawPattern : rawPatterns = filterDescStr.split(PATTERN_SEPARATOR)) {
            this.filterPatterns.add(new PathGlobPatternStatus(rawPattern));
        }
    }

    @Override
    public boolean keep(FieldsPath path) {
        if (this.filterPatterns.isEmpty()) {
            return true;
        }
        for (PathGlobPatternStatus pattern : this.filterPatterns) {
            if (!pattern.matches(path.toDelimitedString("/"))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void assertNoUnmatchedPatterns() throws ThriftProjectionException {
        LinkedList<PathGlobPattern> unmatched = new LinkedList<PathGlobPattern>();
        for (PathGlobPatternStatus p : this.filterPatterns) {
            if (p.hasMatchingPath) continue;
            unmatched.add(p.pattern);
        }
        if (!unmatched.isEmpty()) {
            StringBuilder message = new StringBuilder("The following projection patterns did not match any columns in this schema:\n");
            for (PathGlobPattern p : unmatched) {
                message.append(p);
                message.append('\n');
            }
            throw new ThriftProjectionException(message.toString());
        }
    }

    @Deprecated
    private static class PathGlobPatternStatus {
        PathGlobPattern pattern;
        boolean hasMatchingPath = false;

        PathGlobPatternStatus(String pattern) {
            this.pattern = new PathGlobPattern(pattern);
        }

        public boolean matches(String path) {
            if (this.pattern.matches(path)) {
                this.hasMatchingPath = true;
                return true;
            }
            return false;
        }
    }
}

