/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift;

import org.apache.parquet.thrift.ProtocolPipe;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.protocol.TStruct;

public class ProtocolReadToWrite
implements ProtocolPipe {
    @Override
    public void readOne(TProtocol in, TProtocol out) throws TException {
        this.readOneStruct(in, out);
    }

    void readOneValue(TProtocol in, TProtocol out, byte type) throws TException {
        switch (type) {
            case 15: {
                this.readOneList(in, out);
                break;
            }
            case 13: {
                this.readOneMap(in, out);
                break;
            }
            case 14: {
                this.readOneSet(in, out);
                break;
            }
            case 12: {
                this.readOneStruct(in, out);
                break;
            }
            case 0: {
                break;
            }
            case 2: {
                out.writeBool(in.readBool());
                break;
            }
            case 3: {
                out.writeByte(in.readByte());
                break;
            }
            case 4: {
                out.writeDouble(in.readDouble());
                break;
            }
            case 6: {
                out.writeI16(in.readI16());
                break;
            }
            case -1: 
            case 8: {
                out.writeI32(in.readI32());
                break;
            }
            case 10: {
                out.writeI64(in.readI64());
                break;
            }
            case 11: {
                out.writeBinary(in.readBinary());
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new TException("Unknown type: " + type);
            }
        }
    }

    private void readOneStruct(TProtocol in, TProtocol out) throws TException {
        TStruct struct = in.readStructBegin();
        out.writeStructBegin(struct);
        while (true) {
            TField field = in.readFieldBegin();
            if (field.type == 0) break;
            out.writeFieldBegin(field);
            this.readOneValue(in, out, field.type);
            in.readFieldEnd();
            out.writeFieldEnd();
        }
        out.writeFieldStop();
        in.readStructEnd();
        out.writeStructEnd();
    }

    private void readOneMap(TProtocol in, TProtocol out) throws TException {
        TMap map = in.readMapBegin();
        out.writeMapBegin(map);
        for (int i = 0; i < map.size; ++i) {
            this.readOneValue(in, out, map.keyType);
            this.readOneValue(in, out, map.valueType);
        }
        in.readMapEnd();
        out.writeMapEnd();
    }

    private void readOneSet(TProtocol in, TProtocol out) throws TException {
        TSet set = in.readSetBegin();
        out.writeSetBegin(set);
        this.readCollectionElements(in, out, set.size, set.elemType);
        in.readSetEnd();
        out.writeSetEnd();
    }

    private void readOneList(TProtocol in, TProtocol out) throws TException {
        TList list = in.readListBegin();
        out.writeListBegin(list);
        this.readCollectionElements(in, out, list.size, list.elemType);
        in.readListEnd();
        out.writeListEnd();
    }

    private void readCollectionElements(TProtocol in, TProtocol out, int size, byte elemType) throws TException {
        for (int i = 0; i < size; ++i) {
            this.readOneValue(in, out, elemType);
        }
    }
}

