/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.thrift;

import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.thrift.ThriftReader;
import org.apache.parquet.thrift.ThriftRecordConverter;
import org.apache.parquet.thrift.struct.ThriftType;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;

public class TBaseRecordConverter<T extends TBase<?, ?>>
extends ThriftRecordConverter<T> {
    @Deprecated
    public TBaseRecordConverter(Class<T> thriftClass, MessageType requestedParquetSchema, ThriftType.StructType thriftType) {
        this(thriftClass, requestedParquetSchema, thriftType, null);
    }

    public TBaseRecordConverter(final Class<T> thriftClass, MessageType requestedParquetSchema, ThriftType.StructType thriftType, Configuration conf) {
        super(new ThriftReader<T>(){

            @Override
            public T readOneRecord(TProtocol protocol) throws TException {
                try {
                    TBase thriftObject = (TBase)thriftClass.newInstance();
                    thriftObject.read(protocol);
                    return thriftObject;
                }
                catch (InstantiationException e) {
                    throw new ParquetDecodingException("Could not instantiate Thrift " + thriftClass, (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new ParquetDecodingException("Thrift class or constructor not public " + thriftClass, (Throwable)e);
                }
            }
        }, thriftClass.getSimpleName(), requestedParquetSchema, thriftType, conf);
    }
}

