/*
 * Decompiled with CFR 0.152.
 */
package shaded.parquet.org.apache.thrift.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.parquet.org.apache.thrift.transport.TServerTransport;
import shaded.parquet.org.apache.thrift.transport.TSocket;
import shaded.parquet.org.apache.thrift.transport.TTransportException;

public class TServerSocket
extends TServerTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)TServerSocket.class.getName());
    private ServerSocket serverSocket_ = null;
    private int clientTimeout_ = 0;

    public TServerSocket(ServerSocket serverSocket) throws TTransportException {
        this(serverSocket, 0);
    }

    public TServerSocket(ServerSocket serverSocket, int clientTimeout) throws TTransportException {
        this((ServerSocketTransportArgs)new ServerSocketTransportArgs().serverSocket(serverSocket).clientTimeout(clientTimeout));
    }

    public TServerSocket(int port) throws TTransportException {
        this(port, 0);
    }

    public TServerSocket(int port, int clientTimeout) throws TTransportException {
        this(new InetSocketAddress(port), clientTimeout);
    }

    public TServerSocket(InetSocketAddress bindAddr) throws TTransportException {
        this(bindAddr, 0);
    }

    public TServerSocket(InetSocketAddress bindAddr, int clientTimeout) throws TTransportException {
        this((ServerSocketTransportArgs)((ServerSocketTransportArgs)new ServerSocketTransportArgs().bindAddr(bindAddr)).clientTimeout(clientTimeout));
    }

    public TServerSocket(ServerSocketTransportArgs args) throws TTransportException {
        this.clientTimeout_ = args.clientTimeout;
        if (args.serverSocket != null) {
            this.serverSocket_ = args.serverSocket;
            return;
        }
        try {
            this.serverSocket_ = new ServerSocket();
            this.serverSocket_.setReuseAddress(true);
            this.serverSocket_.bind(args.bindAddr, args.backlog);
        }
        catch (IOException ioe) {
            this.close();
            throw new TTransportException("Could not create ServerSocket on address " + args.bindAddr.toString() + ".", (Throwable)ioe);
        }
    }

    @Override
    public void listen() throws TTransportException {
        if (this.serverSocket_ != null) {
            try {
                this.serverSocket_.setSoTimeout(0);
            }
            catch (SocketException sx) {
                LOGGER.error("Could not set socket timeout.", (Throwable)sx);
            }
        }
    }

    @Override
    protected TSocket acceptImpl() throws TTransportException {
        if (this.serverSocket_ == null) {
            throw new TTransportException(1, "No underlying server socket.");
        }
        try {
            Socket result = this.serverSocket_.accept();
            TSocket result2 = new TSocket(result);
            result2.setTimeout(this.clientTimeout_);
            return result2;
        }
        catch (IOException iox) {
            throw new TTransportException(iox);
        }
    }

    @Override
    public void close() {
        if (this.serverSocket_ != null) {
            try {
                this.serverSocket_.close();
            }
            catch (IOException iox) {
                LOGGER.warn("Could not close server socket.", (Throwable)iox);
            }
            this.serverSocket_ = null;
        }
    }

    @Override
    public void interrupt() {
        this.close();
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket_;
    }

    public static class ServerSocketTransportArgs
    extends TServerTransport.AbstractServerTransportArgs<ServerSocketTransportArgs> {
        ServerSocket serverSocket;

        public ServerSocketTransportArgs serverSocket(ServerSocket serverSocket) {
            this.serverSocket = serverSocket;
            return this;
        }
    }
}

