/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.format.FileMetaData;
import org.apache.parquet.format.Util;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.io.SeekableInputStream;

public class RawUtils {
    private static final ObjectMapper MAPPER = RawUtils.createObjectMapper();

    public static FileMetaData readFooter(SeekableInputStream inputStream, long fileLen) throws IOException {
        byte[] magic = new byte[ParquetFileWriter.MAGIC.length];
        long fileMetadataLengthIndex = fileLen - (long)magic.length - 4L;
        inputStream.seek(fileMetadataLengthIndex);
        int fileMetadataLength = BytesUtils.readIntLittleEndian((InputStream)inputStream);
        inputStream.readFully(magic);
        if (Arrays.equals(ParquetFileWriter.EFMAGIC, magic)) {
            throw new RuntimeException("Parquet files with encrypted footers are not supported.");
        }
        if (!Arrays.equals(ParquetFileWriter.MAGIC, magic)) {
            throw new RuntimeException("Not a Parquet file (expected magic number at tail, but found " + Arrays.toString(magic) + ')');
        }
        long fileMetadataIndex = fileMetadataLengthIndex - (long)fileMetadataLength;
        if (fileMetadataIndex < (long)magic.length || fileMetadataIndex >= fileMetadataLengthIndex) {
            throw new RuntimeException("Corrupted file: the footer index inputStream not within the file: " + fileMetadataIndex);
        }
        inputStream.seek(fileMetadataIndex);
        ByteBuffer footerBytesBuffer = ByteBuffer.allocate(fileMetadataLength);
        inputStream.readFully(footerBytesBuffer);
        footerBytesBuffer.flip();
        ByteBufferInputStream footerBytesStream = ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{footerBytesBuffer});
        return Util.readFileMetaData((InputStream)footerBytesStream);
    }

    public static String prettifyJson(String json) throws JsonProcessingException {
        ObjectMapper mapper = MAPPER;
        Object obj = mapper.readValue(json, Object.class);
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
    }

    public static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
        mapper.registerModule((Module)new JavaTimeModule());
        return mapper;
    }
}

