/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.text.TextStringBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.cli.BaseCommand;
import org.apache.parquet.cli.Util;
import org.apache.parquet.cli.rawpages.RawPagesReader;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.page.DataPage;
import org.apache.parquet.column.page.DataPageV1;
import org.apache.parquet.column.page.DataPageV2;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.page.Page;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.slf4j.Logger;

@Parameters(commandDescription="Print page summaries for a Parquet file")
public class ShowPagesCommand
extends BaseCommand {
    @Parameter(description="<parquet path>")
    List<String> targets;
    @Parameter(names={"-c", "--column", "--columns"}, description="List of columns")
    List<String> columns;
    @Parameter(names={"-r", "--raw"}, description="List the original Thrift page headers and file offsets")
    boolean raw = false;

    public ShowPagesCommand(Logger console) {
        super(console);
    }

    @Override
    public int run() throws IOException {
        Preconditions.checkArgument((this.targets != null && this.targets.size() >= 1 ? 1 : 0) != 0, (Object)"A Parquet file is required.");
        Preconditions.checkArgument((this.targets.size() == 1 ? 1 : 0) != 0, (Object)"Cannot process multiple Parquet files.");
        if (this.raw) {
            try (RawPagesReader reader = new RawPagesReader((InputFile)HadoopInputFile.fromPath((Path)this.qualifiedPath(this.targets.get(0)), (Configuration)this.getConf()), this.columns);){
                reader.listPages(this.console);
            }
            return 0;
        }
        String source = this.targets.get(0);
        try (ParquetFileReader reader = ParquetFileReader.open((Configuration)this.getConf(), (Path)this.qualifiedPath(source));){
            PageReadStore pageStore;
            MessageType schema = reader.getFileMetaData().getSchema();
            LinkedHashMap columns = Maps.newLinkedHashMap();
            if (this.columns == null || this.columns.isEmpty()) {
                for (ColumnDescriptor descriptor : schema.getColumns()) {
                    columns.put(descriptor, Util.primitive(schema, descriptor.getPath()));
                }
            } else {
                for (String column : this.columns) {
                    columns.put(Util.descriptor(column, schema), Util.primitive(column, schema));
                }
            }
            CompressionCodecName codec = ((ColumnChunkMetaData)((BlockMetaData)reader.getRowGroups().get(0)).getColumns().get(0)).getCodec();
            LinkedHashMap formatted = Maps.newLinkedHashMap();
            PageFormatter formatter = new PageFormatter();
            int rowGroupNum = 0;
            while ((pageStore = reader.readNextRowGroup()) != null) {
                for (ColumnDescriptor descriptor : columns.keySet()) {
                    DataPage page;
                    List lines = (List)formatted.get(Util.columnName(descriptor));
                    if (lines == null) {
                        lines = Lists.newArrayList();
                        formatted.put(Util.columnName(descriptor), lines);
                    }
                    formatter.setContext(rowGroupNum, (PrimitiveType)columns.get(descriptor), codec);
                    PageReader pages = pageStore.getPageReader(descriptor);
                    DictionaryPage dict = pages.readDictionaryPage();
                    if (dict != null) {
                        lines.add(formatter.format((Page)dict));
                    }
                    while ((page = pages.readPage()) != null) {
                        lines.add(formatter.format((Page)page));
                    }
                }
                ++rowGroupNum;
                pageStore.close();
            }
            for (String columnName : formatted.keySet()) {
                this.console.info(String.format("\nColumn: %s\n%s", columnName, new TextStringBuilder(80).appendPadding(80, '-')));
                this.console.info(formatter.getHeader());
                for (String line : (List)formatted.get(columnName)) {
                    this.console.info(line);
                }
                this.console.info("");
            }
        }
        return 0;
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# Show pages for column 'col' from a Parquet file", "-c col sample.parquet"});
    }

    private class PageFormatter
    implements DataPage.Visitor<String> {
        private int rowGroupNum;
        private int pageNum;
        private PrimitiveType type;
        private String shortCodec;

        private PageFormatter() {
        }

        String getHeader() {
            return String.format("  %-6s %-5s %-4s %-7s %-10s %-10s %-8s %-7s %s", "page", "type", "enc", "count", "avg size", "size", "rows", "nulls", "min / max");
        }

        void setContext(int rowGroupNum, PrimitiveType type, CompressionCodecName codec) {
            this.rowGroupNum = rowGroupNum;
            this.pageNum = 0;
            this.type = type;
            this.shortCodec = Util.shortCodec(codec);
        }

        String format(Page page) {
            String formatted = "";
            if (page instanceof DictionaryPage) {
                formatted = this.printDictionaryPage((DictionaryPage)page);
            } else if (page instanceof DataPage) {
                formatted = (String)((DataPage)page).accept((DataPage.Visitor)this);
            }
            ++this.pageNum;
            return formatted;
        }

        private String printDictionaryPage(DictionaryPage dict) {
            dict.getUncompressedSize();
            long totalSize = dict.getCompressedSize();
            int count = dict.getDictionarySize();
            float perValue = (float)totalSize / (float)count;
            String enc = Util.encodingAsString(dict.getEncoding(), true);
            if (this.pageNum == 0) {
                return String.format("%3d-D    %-5s %s %-2s %-7d %-10s %-10s", this.rowGroupNum, "dict", this.shortCodec, enc, count, Util.humanReadable(perValue), Util.humanReadable(totalSize));
            }
            return String.format("%3d-%-3d  %-5s %s %-2s %-7d %-10s %-10s", this.rowGroupNum, this.pageNum, "dict", this.shortCodec, enc, count, Util.humanReadable(perValue), Util.humanReadable(totalSize));
        }

        public String visit(DataPageV1 page) {
            String enc = Util.encodingAsString(page.getValueEncoding(), false);
            long totalSize = page.getCompressedSize();
            int count = page.getValueCount();
            String numNulls = page.getStatistics().isNumNullsSet() ? Long.toString(page.getStatistics().getNumNulls()) : "";
            float perValue = (float)totalSize / (float)count;
            String minMax = Util.minMaxAsString(page.getStatistics());
            return String.format("%3d-%-3d  %-5s %s %-2s %-7d %-10s %-10s %-8s %-7s %s", this.rowGroupNum, this.pageNum, "data", this.shortCodec, enc, count, Util.humanReadable(perValue), Util.humanReadable(totalSize), "", numNulls, minMax);
        }

        public String visit(DataPageV2 page) {
            String enc = Util.encodingAsString(page.getDataEncoding(), false);
            long totalSize = page.getCompressedSize();
            int count = page.getValueCount();
            int numRows = page.getRowCount();
            int numNulls = page.getNullCount();
            float perValue = (float)totalSize / (float)count;
            String minMax = Util.minMaxAsString(page.getStatistics());
            String compression = page.isCompressed() ? this.shortCodec : "_";
            return String.format("%3d-%-3d  %-5s %s %-2s %-7d %-10s %-10s %-8d %-7s %s", this.rowGroupNum, this.pageNum, "data", compression, enc, count, Util.humanReadable(perValue), Util.humanReadable(totalSize), numRows, numNulls, minMax);
        }
    }
}

