/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.parquet.cli.BaseCommand;
import org.apache.parquet.cli.util.Expressions;
import org.slf4j.Logger;

@Parameters(commandDescription="Print the first N records from a file")
public class CatCommand
extends BaseCommand {
    @Parameter(description="<file>")
    List<String> sourceFiles;
    @Parameter(names={"-n", "--num-records"}, description="The number of records to print")
    long numRecords;
    @Parameter(names={"-c", "--column", "--columns"}, description="List of columns")
    List<String> columns;

    public CatCommand(Logger console, long defaultNumRecords) {
        super(console);
        this.numRecords = defaultNumRecords;
    }

    @Override
    public int run() throws IOException {
        Preconditions.checkArgument((this.sourceFiles != null && !this.sourceFiles.isEmpty() ? 1 : 0) != 0, (Object)"Missing file name");
        HashMap<String, Schema> schemas = new HashMap<String, Schema>();
        for (String source : this.sourceFiles) {
            Schema schema = this.getAvroSchema(source);
            schemas.put(source, Expressions.filterSchema(schema, this.columns));
        }
        for (String source : this.sourceFiles) {
            Schema projection = (Schema)schemas.get(source);
            Iterable reader = this.openDataFile(source, projection);
            boolean threw = true;
            long count = 0L;
            try {
                for (Object record : reader) {
                    if (this.numRecords > 0L && count >= this.numRecords) break;
                    if (this.columns == null || this.columns.size() != 1) {
                        this.console.info(String.valueOf(record));
                    } else {
                        this.console.info(String.valueOf(Expressions.select(projection, record, this.columns.get(0))));
                    }
                    ++count;
                }
                threw = false;
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Failed on record " + count + " in file " + source, e);
            }
            finally {
                if (!(reader instanceof Closeable)) continue;
                Closeables.close((Closeable)((Closeable)((Object)reader)), (boolean)threw);
            }
        }
        return 0;
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# Show the first 10 records in file \"data.avro\":", "data.avro", "# Show the first 50 records in file \"data.parquet\":", "data.parquet -n 50"});
    }
}

