/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.service.messages;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.service.network.messages.MessageBody;
import org.apache.paimon.service.network.messages.MessageDeserializer;
import org.apache.paimon.shade.netty4.io.netty.buffer.ByteBuf;
import org.apache.paimon.utils.SerializationUtils;

public class KvResponse
extends MessageBody {
    private final BinaryRow[] values;

    public KvResponse(BinaryRow[] values) {
        this.values = values;
    }

    public BinaryRow[] values() {
        return this.values;
    }

    @Override
    public byte[] serialize() {
        int size = 4;
        byte[][] valueBytesArray = new byte[this.values.length][];
        for (int i = 0; i < this.values.length; ++i) {
            BinaryRow value = this.values[i];
            ++size;
            if (value == null) continue;
            byte[] valueBytes = SerializationUtils.serializeBinaryRow((BinaryRow)value);
            valueBytesArray[i] = valueBytes;
            size += 4 + valueBytes.length;
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.putInt(valueBytesArray.length);
        for (byte[] valueBytes : valueBytesArray) {
            if (valueBytes == null) {
                buffer.put((byte)1);
                continue;
            }
            buffer.put((byte)0);
            buffer.putInt(valueBytes.length).put(valueBytes);
        }
        return buffer.array();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KvResponse that = (KvResponse)o;
        return Arrays.equals(this.values, that.values);
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public static class KvResponseDeserializer
    implements MessageDeserializer<KvResponse> {
        @Override
        public KvResponse deserializeMessage(ByteBuf buf) {
            int valueSize = buf.readInt();
            BinaryRow[] values = new BinaryRow[valueSize];
            for (int i = 0; i < valueSize; ++i) {
                if (buf.readByte() == 1) continue;
                values[i] = SerializationUtils.deserializeBinaryRow((byte[])MessageDeserializer.readBytes(buf, buf.readInt()));
            }
            return new KvResponse(values);
        }
    }
}

