/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.iceberg;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.PartitionData;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.BinaryWriter;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.SeekableInputStream;
import org.apache.paimon.hive.clone.HivePartitionFiles;
import org.apache.paimon.hive.clone.HiveTableCloneExtractor;
import org.apache.paimon.migrate.FileMetaUtils;
import org.apache.paimon.partition.PartitionPredicate;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergHiveCloneExtractor
extends HiveTableCloneExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergHiveCloneExtractor.class);

    public boolean matches(Table table) {
        return table.getParameters().getOrDefault("table_type", "").equalsIgnoreCase("iceberg");
    }

    public List<HivePartitionFiles> extractFiles(Map<String, String> catalogOptions, IMetaStoreClient client, Table table, FileIO fileIO, Identifier identifier, RowType partitionRowType, String defaultPartitionName, @Nullable PartitionPredicate predicate) throws Exception {
        String metadataPath = (String)table.getParameters().get("metadata_location");
        String metadataJson = fileIO.readFileUtf8(new Path(metadataPath));
        TableMetadata metadata = TableMetadataParser.fromJson((String)metadataJson);
        Snapshot currentSnapshot = metadata.currentSnapshot();
        if (metadata.schemas().size() > 1) {
            LOG.warn("more than 1 schemas in iceberg!");
        }
        Preconditions.checkArgument((metadata.specs().size() == 1 ? 1 : 0) != 0, (String)"do not support clone iceberg table which had more than 1 partitionSpec.table: %s, specs: %s", (Object[])new Object[]{identifier.toString(), metadata.specs()});
        IcebergFileIO icebergFileIO = new IcebergFileIO(fileIO);
        List dataManifests = currentSnapshot.dataManifests((org.apache.iceberg.io.FileIO)icebergFileIO);
        List deleteManifests = currentSnapshot.deleteManifests((org.apache.iceberg.io.FileIO)icebergFileIO);
        Preconditions.checkArgument((boolean)deleteManifests.isEmpty(), (String)"do not support clone iceberg table which had 'DELETE' manifest file. table: %s, size of deleteManifests: %s.", (Object[])new Object[]{identifier.toString(), deleteManifests.size()});
        List<DataFile> dataFiles = this.readDataEntries(dataManifests, icebergFileIO);
        if (partitionRowType.getFieldCount() == 0) {
            return Collections.singletonList(this.toHivePartitionFiles(dataFiles, BinaryRow.EMPTY_ROW));
        }
        ArrayList<HivePartitionFiles> results = new ArrayList<HivePartitionFiles>();
        ArrayList valueSetters = new ArrayList();
        partitionRowType.getFieldTypes().forEach(type -> valueSetters.add(BinaryWriter.createValueSetter((DataType)type)));
        Map<StructLike, List<DataFile>> groupedDataFiles = dataFiles.stream().collect(Collectors.groupingBy(ContentFile::partition));
        for (Map.Entry<StructLike, List<DataFile>> entry : groupedDataFiles.entrySet()) {
            List<Object> partitionValues = this.partitionToObjects(partitionRowType, (PartitionData)entry.getKey());
            BinaryRow partitionRow = FileMetaUtils.writePartitionValue((RowType)partitionRowType, partitionValues, valueSetters);
            if (predicate != null && !predicate.test(partitionRow)) continue;
            results.add(this.toHivePartitionFiles(entry.getValue(), partitionRow));
        }
        return results;
    }

    public List<String> extractPartitionKeys(Table table) {
        String schemaJson = (String)table.getParameters().get("current-schema");
        String specJson = table.getParameters().getOrDefault("default-partition-spec", "");
        if (specJson.isEmpty()) {
            return Collections.emptyList();
        }
        PartitionSpec spec = PartitionSpecParser.fromJson((Schema)SchemaParser.fromJson((String)schemaJson), (String)specJson);
        return spec.fields().stream().map(PartitionField::name).collect(Collectors.toList());
    }

    public Map<String, String> extractOptions(Table table) {
        Map hiveTableOptions = table.getParameters();
        HashMap<String, String> paimonOptions = new HashMap<String, String>();
        String comment = (String)hiveTableOptions.get("comment");
        if (comment != null) {
            paimonOptions.put("hive.comment", comment);
            paimonOptions.put("comment", comment);
        }
        String format = table.getParameters().getOrDefault("write.format.default", "parquet");
        paimonOptions.put(CoreOptions.FILE_FORMAT.key(), format);
        Map formatOptions = IcebergHiveCloneExtractor.getIdentifierPrefixOptions((String)("write." + format), (Map)hiveTableOptions);
        Map sdFormatOptions = IcebergHiveCloneExtractor.getIdentifierPrefixOptions((String)("write." + format), (Map)table.getSd().getSerdeInfo().getParameters());
        formatOptions.putAll(sdFormatOptions);
        paimonOptions.putAll(formatOptions);
        String compression = this.parseCompression(format, formatOptions);
        if (compression != null) {
            paimonOptions.put(CoreOptions.FILE_COMPRESSION.key(), compression);
        }
        return paimonOptions;
    }

    public boolean supportCloneSplits(String format) {
        return false;
    }

    private HivePartitionFiles toHivePartitionFiles(List<DataFile> dataFiles, BinaryRow partition) {
        ArrayList<Path> paths = new ArrayList<Path>(dataFiles.size());
        ArrayList<Long> fileSizes = new ArrayList<Long>(dataFiles.size());
        String format = null;
        for (DataFile file : dataFiles) {
            Path path = new Path(file.path().toString());
            if (format == null) {
                format = file.format().toString();
            }
            long fileSize = file.fileSizeInBytes();
            paths.add(path);
            fileSizes.add(fileSize);
        }
        return new HivePartitionFiles(partition, paths, fileSizes, format);
    }

    private List<DataFile> readDataEntries(List<ManifestFile> dataManifests, org.apache.iceberg.io.FileIO io) {
        ArrayList<DataFile> dateEntries = new ArrayList<DataFile>();
        for (ManifestFile dataManifest : dataManifests) {
            for (DataFile dataFile : ManifestFiles.read((ManifestFile)dataManifest, (org.apache.iceberg.io.FileIO)io)) {
                dateEntries.add(dataFile);
            }
        }
        return dateEntries;
    }

    private List<Object> partitionToObjects(RowType partitionRowType, PartitionData partition) {
        Preconditions.checkArgument((partition.size() == partitionRowType.getFieldCount() ? 1 : 0) != 0);
        ArrayList<Object> objects = new ArrayList<Object>();
        for (int i = 0; i < partition.size(); ++i) {
            objects.add(partition.get(i));
        }
        return objects;
    }

    private String parseCompression(String format, Map<String, String> formatOptions) {
        String compression = null;
        if (Objects.equals(format, "avro")) {
            compression = formatOptions.getOrDefault("write.avro.compression-codec", "gzip");
        } else if (Objects.equals(format, "parquet")) {
            compression = formatOptions.getOrDefault("write.parquet.compression-codec", "zstd");
        } else if (Objects.equals(format, "orc")) {
            compression = formatOptions.getOrDefault("write.orc.compression-codec", "zlib");
        }
        return compression;
    }

    private static class IcebergSeekableStreamAdapter
    extends org.apache.iceberg.io.SeekableInputStream {
        private final SeekableInputStream paimonStream;

        IcebergSeekableStreamAdapter(SeekableInputStream paimonStream) {
            this.paimonStream = paimonStream;
        }

        public long getPos() throws IOException {
            return this.paimonStream.getPos();
        }

        public void seek(long newPos) throws IOException {
            this.paimonStream.seek(newPos);
        }

        public int read() throws IOException {
            return this.paimonStream.read();
        }
    }

    private static class IcebergFileIO
    implements org.apache.iceberg.io.FileIO {
        private final FileIO fileIO;

        public IcebergFileIO(FileIO fileIO) {
            this.fileIO = fileIO;
        }

        public InputFile newInputFile(final String path) {
            return new InputFile(){

                public long getLength() {
                    try {
                        return fileIO.getFileSize(new Path(path));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                public org.apache.iceberg.io.SeekableInputStream newStream() {
                    try {
                        SeekableInputStream inputStream = fileIO.newInputStream(new Path(path));
                        return new IcebergSeekableStreamAdapter(inputStream);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public String location() {
                    return path;
                }

                public boolean exists() {
                    return true;
                }
            };
        }

        public OutputFile newOutputFile(String path) {
            throw new UnsupportedOperationException();
        }

        public void deleteFile(String path) {
            throw new UnsupportedOperationException();
        }
    }
}

