/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.utils.Preconditions;

public class BitSet {
    private static final int BYTE_INDEX_MASK = 7;
    private MemorySegment memorySegment;
    private int offset;
    private final int byteLength;
    private final int bitLength;

    public BitSet(int byteSize) {
        Preconditions.checkArgument((byteSize > 0 ? 1 : 0) != 0, (Object)"bits size should be greater than 0.");
        this.byteLength = byteSize;
        this.bitLength = byteSize << 3;
    }

    public void setMemorySegment(MemorySegment memorySegment, int offset) {
        Preconditions.checkArgument((memorySegment != null ? 1 : 0) != 0, (Object)"MemorySegment can not be null.");
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (Object)"Offset should be positive integer.");
        Preconditions.checkArgument((offset + this.byteLength <= memorySegment.size() ? 1 : 0) != 0, (Object)"Could not set MemorySegment, the remain buffers is not enough.");
        this.memorySegment = memorySegment;
        this.offset = offset;
    }

    public void unsetMemorySegment() {
        this.memorySegment = null;
    }

    public MemorySegment getMemorySegment() {
        return this.memorySegment;
    }

    public void set(int index) {
        Preconditions.checkArgument((index < this.bitLength && index >= 0 ? 1 : 0) != 0);
        int byteIndex = index >>> 3;
        byte current = this.memorySegment.get(this.offset + byteIndex);
        current = (byte)(current | 1 << (index & 7));
        this.memorySegment.put(this.offset + byteIndex, current);
    }

    public boolean get(int index) {
        Preconditions.checkArgument((index < this.bitLength && index >= 0 ? 1 : 0) != 0);
        int byteIndex = index >>> 3;
        byte current = this.memorySegment.get(this.offset + byteIndex);
        return (current & 1 << (index & 7)) != 0;
    }

    public int bitSize() {
        return this.bitLength;
    }

    public void clear() {
        int index = 0;
        while (index + 8 <= this.byteLength) {
            this.memorySegment.putLong(this.offset + index, 0L);
            index += 8;
        }
        while (index < this.byteLength) {
            this.memorySegment.put(this.offset + index, (byte)0);
            ++index;
        }
    }

    public String toString() {
        return "BitSet:\n\tMemorySegment:" + this.memorySegment.size() + "\n\tOffset:" + this.offset + "\n\tLength:" + this.byteLength + "\n";
    }
}

