/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data.serializer;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.paimon.data.serializer.Serializer;
import org.apache.paimon.io.DataInputDeserializer;
import org.apache.paimon.io.DataInputView;
import org.apache.paimon.io.DataOutputSerializer;
import org.apache.paimon.io.DataOutputView;
import org.apache.paimon.utils.Preconditions;

public class NullableSerializer<T>
implements Serializer<T> {
    private static final long serialVersionUID = 1L;
    private final Serializer<T> originalSerializer;

    private NullableSerializer(Serializer<T> originalSerializer) {
        this.originalSerializer = originalSerializer;
    }

    public static <T> Serializer<T> wrapIfNullIsNotSupported(@Nonnull Serializer<T> originalSerializer) {
        return NullableSerializer.checkIfNullSupported(originalSerializer) ? originalSerializer : NullableSerializer.wrap(originalSerializer);
    }

    public static <T> boolean checkIfNullSupported(Serializer<T> serializer) {
        DataOutputSerializer dos = new DataOutputSerializer(10);
        try {
            serializer.serialize(null, dos);
        }
        catch (IOException | RuntimeException e) {
            return false;
        }
        DataInputDeserializer dis = new DataInputDeserializer(dos.getSharedBuffer());
        try {
            Preconditions.checkArgument((serializer.deserialize(dis) == null ? 1 : 0) != 0);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unexpected failure to deserialize just serialized null value with %s", serializer.getClass().getName()), e);
        }
        Preconditions.checkArgument((serializer.copy(null) == null ? 1 : 0) != 0, (String)"Serializer %s has to be able properly copy null value if it can serialize it", (Object[])new Object[]{serializer.getClass().getName()});
        return true;
    }

    private Serializer<T> originalSerializer() {
        return this.originalSerializer;
    }

    public static <T> Serializer<T> wrap(Serializer<T> originalSerializer) {
        return originalSerializer instanceof NullableSerializer ? originalSerializer : new NullableSerializer<T>(originalSerializer);
    }

    @Override
    public Serializer<T> duplicate() {
        Serializer<T> duplicateOriginalSerializer = this.originalSerializer.duplicate();
        return duplicateOriginalSerializer == this.originalSerializer ? this : new NullableSerializer<T>(this.originalSerializer.duplicate());
    }

    @Override
    public T copy(T from) {
        return from == null ? null : (T)this.originalSerializer.copy(from);
    }

    @Override
    public void serialize(T record, DataOutputView target) throws IOException {
        if (record == null) {
            target.writeBoolean(true);
        } else {
            target.writeBoolean(false);
            this.originalSerializer.serialize(record, target);
        }
    }

    @Override
    public T deserialize(DataInputView source) throws IOException {
        boolean isNull = this.deserializeNull(source);
        return isNull ? null : (T)this.originalSerializer.deserialize(source);
    }

    private boolean deserializeNull(DataInputView source) throws IOException {
        return source.readBoolean();
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass() == this.getClass() && this.originalSerializer.equals(((NullableSerializer)obj).originalSerializer);
    }

    public int hashCode() {
        return this.originalSerializer.hashCode();
    }
}

