/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.types;

import java.util.Arrays;
import java.util.OptionalInt;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.BinaryType;
import org.apache.paimon.types.BooleanType;
import org.apache.paimon.types.CharType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeDefaultVisitor;
import org.apache.paimon.types.DateType;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.DoubleType;
import org.apache.paimon.types.FloatType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.SmallIntType;
import org.apache.paimon.types.TimeType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.types.TinyIntType;
import org.apache.paimon.types.VarBinaryType;
import org.apache.paimon.types.VarCharType;
import org.apache.paimon.types.VariantType;

@Public
public class DataTypes {
    private static final PrecisionExtractor PRECISION_EXTRACTOR = new PrecisionExtractor();
    private static final LengthExtractor LENGTH_EXTRACTOR = new LengthExtractor();

    public static IntType INT() {
        return new IntType();
    }

    public static TinyIntType TINYINT() {
        return new TinyIntType();
    }

    public static SmallIntType SMALLINT() {
        return new SmallIntType();
    }

    public static BigIntType BIGINT() {
        return new BigIntType();
    }

    public static VarCharType STRING() {
        return VarCharType.STRING_TYPE;
    }

    public static DoubleType DOUBLE() {
        return new DoubleType();
    }

    public static ArrayType ARRAY(DataType element) {
        return new ArrayType(element);
    }

    public static CharType CHAR(int length) {
        return new CharType(length);
    }

    public static VarCharType VARCHAR(int length) {
        return new VarCharType(length);
    }

    public static BooleanType BOOLEAN() {
        return new BooleanType();
    }

    public static DateType DATE() {
        return new DateType();
    }

    public static TimeType TIME() {
        return new TimeType();
    }

    public static TimeType TIME(int precision) {
        return new TimeType(precision);
    }

    public static TimestampType TIMESTAMP() {
        return new TimestampType();
    }

    public static TimestampType TIMESTAMP_MILLIS() {
        return new TimestampType(3);
    }

    public static TimestampType TIMESTAMP(int precision) {
        return new TimestampType(precision);
    }

    public static LocalZonedTimestampType TIMESTAMP_WITH_LOCAL_TIME_ZONE() {
        return new LocalZonedTimestampType();
    }

    public static LocalZonedTimestampType TIMESTAMP_WITH_LOCAL_TIME_ZONE(int precision) {
        return new LocalZonedTimestampType(precision);
    }

    public static LocalZonedTimestampType TIMESTAMP_LTZ_MILLIS() {
        return new LocalZonedTimestampType(3);
    }

    public static DecimalType DECIMAL(int precision, int scale) {
        return new DecimalType(precision, scale);
    }

    public static VarBinaryType BYTES() {
        return new VarBinaryType(Integer.MAX_VALUE);
    }

    public static FloatType FLOAT() {
        return new FloatType();
    }

    public static MapType MAP(DataType keyType, DataType valueType) {
        return new MapType(keyType, valueType);
    }

    public static DataField FIELD(int id, String name, DataType type) {
        return new DataField(id, name, type);
    }

    public static DataField FIELD(int id, String name, DataType type, String description) {
        return new DataField(id, name, type, description);
    }

    public static RowType ROW(DataField ... fields) {
        return new RowType(Arrays.asList(fields));
    }

    public static RowType ROW(DataType ... fieldTypes) {
        return RowType.builder().fields(fieldTypes).build();
    }

    public static BinaryType BINARY(int length) {
        return new BinaryType(length);
    }

    public static VarBinaryType VARBINARY(int length) {
        return new VarBinaryType(length);
    }

    public static MultisetType MULTISET(DataType elementType) {
        return new MultisetType(elementType);
    }

    public static VariantType VARIANT() {
        return new VariantType();
    }

    public static OptionalInt getPrecision(DataType dataType) {
        return dataType.accept(PRECISION_EXTRACTOR);
    }

    public static OptionalInt getLength(DataType dataType) {
        return dataType.accept(LENGTH_EXTRACTOR);
    }

    private static class LengthExtractor
    extends DataTypeDefaultVisitor<OptionalInt> {
        private LengthExtractor() {
        }

        @Override
        public OptionalInt visit(CharType charType) {
            return OptionalInt.of(charType.getLength());
        }

        @Override
        public OptionalInt visit(VarCharType varCharType) {
            return OptionalInt.of(varCharType.getLength());
        }

        @Override
        public OptionalInt visit(BinaryType binaryType) {
            return OptionalInt.of(binaryType.getLength());
        }

        @Override
        public OptionalInt visit(VarBinaryType varBinaryType) {
            return OptionalInt.of(varBinaryType.getLength());
        }

        @Override
        protected OptionalInt defaultMethod(DataType dataType) {
            return OptionalInt.empty();
        }
    }

    private static class PrecisionExtractor
    extends DataTypeDefaultVisitor<OptionalInt> {
        private PrecisionExtractor() {
        }

        @Override
        public OptionalInt visit(DecimalType decimalType) {
            return OptionalInt.of(decimalType.getPrecision());
        }

        @Override
        public OptionalInt visit(TimeType timeType) {
            return OptionalInt.of(timeType.getPrecision());
        }

        @Override
        public OptionalInt visit(TimestampType timestampType) {
            return OptionalInt.of(timestampType.getPrecision());
        }

        @Override
        public OptionalInt visit(LocalZonedTimestampType localZonedTimestampType) {
            return OptionalInt.of(localZonedTimestampType.getPrecision());
        }

        @Override
        protected OptionalInt defaultMethod(DataType dataType) {
            return OptionalInt.empty();
        }
    }
}

