/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.options;

import java.time.Duration;

public class ExpireConfig {
    private final int snapshotRetainMax;
    private final int snapshotRetainMin;
    private final Duration snapshotTimeRetain;
    private final int snapshotMaxDeletes;
    private final int changelogRetainMax;
    private final int changelogRetainMin;
    private final Duration changelogTimeRetain;
    private final int changelogMaxDeletes;
    private final boolean changelogDecoupled;

    public ExpireConfig(int snapshotRetainMax, int snapshotRetainMin, Duration snapshotTimeRetain, int snapshotMaxDeletes, int changelogRetainMax, int changelogRetainMin, Duration changelogTimeRetain, int changelogMaxDeletes) {
        this.snapshotRetainMax = snapshotRetainMax;
        this.snapshotRetainMin = snapshotRetainMin;
        this.snapshotTimeRetain = snapshotTimeRetain;
        this.snapshotMaxDeletes = snapshotMaxDeletes;
        this.changelogRetainMax = changelogRetainMax;
        this.changelogRetainMin = changelogRetainMin;
        this.changelogTimeRetain = changelogTimeRetain;
        this.changelogMaxDeletes = changelogMaxDeletes;
        this.changelogDecoupled = changelogRetainMax > snapshotRetainMax || changelogRetainMin > snapshotRetainMin || changelogTimeRetain.compareTo(snapshotTimeRetain) > 0;
    }

    public int getSnapshotRetainMax() {
        return this.snapshotRetainMax;
    }

    public int getSnapshotRetainMin() {
        return this.snapshotRetainMin;
    }

    public Duration getSnapshotTimeRetain() {
        return this.snapshotTimeRetain;
    }

    public int getChangelogRetainMax() {
        return this.changelogRetainMax;
    }

    public int getChangelogRetainMin() {
        return this.changelogRetainMin;
    }

    public Duration getChangelogTimeRetain() {
        return this.changelogTimeRetain;
    }

    public int getSnapshotMaxDeletes() {
        return this.snapshotMaxDeletes;
    }

    public int getChangelogMaxDeletes() {
        return this.changelogMaxDeletes;
    }

    public boolean isChangelogDecoupled() {
        return this.changelogDecoupled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private int snapshotRetainMax = Integer.MAX_VALUE;
        private int snapshotRetainMin = 1;
        private Duration snapshotTimeRetain = Duration.ofMillis(Long.MAX_VALUE);
        private int snapshotMaxDeletes = Integer.MAX_VALUE;
        private Integer changelogRetainMax = null;
        private Integer changelogRetainMin = null;
        private Duration changelogTimeRetain = null;
        private Integer changelogMaxDeletes = null;

        public static Builder builder() {
            return new Builder();
        }

        public Builder snapshotRetainMax(int snapshotRetainMax) {
            this.snapshotRetainMax = snapshotRetainMax;
            return this;
        }

        public Builder snapshotRetainMin(int snapshotRetainMin) {
            this.snapshotRetainMin = snapshotRetainMin;
            return this;
        }

        public Builder snapshotTimeRetain(Duration snapshotTimeRetain) {
            this.snapshotTimeRetain = snapshotTimeRetain;
            return this;
        }

        public Builder snapshotMaxDeletes(int snapshotMaxDeletes) {
            this.snapshotMaxDeletes = snapshotMaxDeletes;
            return this;
        }

        public Builder changelogRetainMax(Integer changelogRetainMax) {
            this.changelogRetainMax = changelogRetainMax;
            return this;
        }

        public Builder changelogRetainMin(Integer changelogRetainMin) {
            this.changelogRetainMin = changelogRetainMin;
            return this;
        }

        public Builder changelogTimeRetain(Duration changelogTimeRetain) {
            this.changelogTimeRetain = changelogTimeRetain;
            return this;
        }

        public Builder changelogMaxDeletes(Integer changelogMaxDeletes) {
            this.changelogMaxDeletes = changelogMaxDeletes;
            return this;
        }

        public ExpireConfig build() {
            return new ExpireConfig(this.snapshotRetainMax, this.snapshotRetainMin, this.snapshotTimeRetain, this.snapshotMaxDeletes, this.changelogRetainMax == null ? this.snapshotRetainMax : this.changelogRetainMax, this.changelogRetainMin == null ? this.snapshotRetainMin : this.changelogRetainMin, this.changelogTimeRetain == null ? this.snapshotTimeRetain : this.changelogTimeRetain, this.changelogMaxDeletes == null ? this.snapshotMaxDeletes : this.changelogMaxDeletes);
        }
    }
}

