/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.text;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FormatWriter;
import org.apache.paimon.format.HadoopCompressionType;
import org.apache.paimon.format.text.HadoopCompressionUtils;
import org.apache.paimon.fs.PositionOutputStream;
import org.apache.paimon.types.RowType;

public abstract class BaseTextFileWriter
implements FormatWriter {
    protected final PositionOutputStream outputStream;
    protected final BufferedWriter writer;
    protected final RowType rowType;

    protected BaseTextFileWriter(PositionOutputStream outputStream, RowType rowType, String compression) throws IOException {
        this.outputStream = outputStream;
        OutputStream compressedStream = HadoopCompressionUtils.createCompressedOutputStream(outputStream, compression);
        this.writer = new BufferedWriter(new OutputStreamWriter(compressedStream, StandardCharsets.UTF_8), this.getOptimalBufferSize(compression));
        this.rowType = rowType;
    }

    @Override
    public abstract void addElement(InternalRow var1) throws IOException;

    @Override
    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }

    @Override
    public boolean reachTargetSize(boolean suggestedCheck, long targetSize) throws IOException {
        if (suggestedCheck) {
            return this.outputStream.getPos() >= targetSize;
        }
        return false;
    }

    private int getOptimalBufferSize(String compression) {
        HadoopCompressionType type = HadoopCompressionType.fromValue(compression).orElseThrow(IllegalArgumentException::new);
        switch (type) {
            case GZIP: 
            case DEFLATE: {
                return 65536;
            }
            case SNAPPY: 
            case LZ4: {
                return 131072;
            }
            case ZSTD: {
                return 262144;
            }
            case BZIP2: {
                return 65536;
            }
        }
        return 65536;
    }
}

