/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.avro;

import java.io.IOException;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.avro.FieldReaderFactory;
import org.apache.paimon.shade.org.apache.avro.Schema;
import org.apache.paimon.shade.org.apache.avro.io.DatumReader;
import org.apache.paimon.shade.org.apache.avro.io.Decoder;
import org.apache.paimon.types.RowType;

public class AvroRowDatumReader
implements DatumReader<InternalRow> {
    private final RowType projectedRowType;
    private FieldReaderFactory.RowReader reader;
    private boolean isUnion;

    public AvroRowDatumReader(RowType projectedRowType) {
        this.projectedRowType = projectedRowType;
    }

    @Override
    public void setSchema(Schema schema) {
        this.isUnion = false;
        if (schema.isUnion()) {
            this.isUnion = true;
            schema = schema.getTypes().get(1);
        }
        this.reader = new FieldReaderFactory().createRowReader(schema, this.projectedRowType.getFields());
    }

    @Override
    public InternalRow read(InternalRow reuse, Decoder in) throws IOException {
        int index;
        if (this.isUnion && (index = in.readIndex()) == 0) {
            throw new RuntimeException("Cannot read a null row.");
        }
        return this.reader.read(in, reuse);
    }
}

