/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data;

import java.io.Serializable;
import java.util.List;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.BinaryRowWriter;
import org.apache.paimon.data.BinaryWriter;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.data.serializer.InternalSerializers;
import org.apache.paimon.data.serializer.Serializer;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeChecks;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.TimestampType;

public class RowHelper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final InternalRow.FieldGetter[] fieldGetters;
    private final BinaryWriter.ValueSetter[] valueSetters;
    private final boolean[] writeNulls;
    private final Serializer<?>[] serializers;
    private transient BinaryRow reuseRow;
    private transient BinaryRowWriter reuseWriter;

    public RowHelper(List<DataType> types) {
        this.fieldGetters = new InternalRow.FieldGetter[types.size()];
        this.valueSetters = new BinaryWriter.ValueSetter[types.size()];
        this.writeNulls = new boolean[types.size()];
        this.serializers = (Serializer[])types.stream().map(InternalSerializers::create).toArray(Serializer[]::new);
        for (int i = 0; i < types.size(); ++i) {
            DataType type = types.get(i);
            this.fieldGetters[i] = InternalRow.createFieldGetter(type, i);
            this.valueSetters[i] = BinaryWriter.createValueSetter(type, this.serializers[i]);
            if (type instanceof DecimalType) {
                this.writeNulls[i] = !Decimal.isCompact(DataTypeChecks.getPrecision(type));
                continue;
            }
            if (!(type instanceof TimestampType) && !(type instanceof LocalZonedTimestampType)) continue;
            this.writeNulls[i] = !Timestamp.isCompact(DataTypeChecks.getPrecision(type));
        }
    }

    public void copyInto(InternalRow row) {
        if (this.reuseRow == null) {
            this.reuseRow = new BinaryRow(this.fieldGetters.length);
            this.reuseWriter = new BinaryRowWriter(this.reuseRow);
        }
        this.reuseWriter.reset();
        this.reuseWriter.writeRowKind(row.getRowKind());
        for (int i = 0; i < this.fieldGetters.length; ++i) {
            Object field = this.fieldGetters[i].getFieldOrNull(row);
            if (field == null && !this.writeNulls[i]) {
                this.reuseWriter.setNullAt(i);
                continue;
            }
            this.valueSetters[i].setValue(this.reuseWriter, i, field);
        }
        this.reuseWriter.complete();
    }

    public BinaryRow reuseRow() {
        return this.reuseRow;
    }

    public BinaryRow copiedRow() {
        return this.reuseRow.copy();
    }

    public Serializer serializer(int i) {
        return this.serializers[i];
    }

    public InternalRow.FieldGetter fieldGetter(int i) {
        return this.fieldGetters[i];
    }
}

