/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.repair.om;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.hdds.utils.db.StringCodec;
import org.apache.hadoop.hdds.utils.db.managed.ManagedConfigOptions;
import org.apache.hadoop.hdds.utils.db.managed.ManagedDBOptions;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksDB;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksIterator;
import org.apache.hadoop.ozone.debug.RocksDBUtils;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.repair.RepairTool;
import org.apache.hadoop.ozone.shell.bucket.BucketUri;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.DBOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="chain", description={"CLI to update global and path previous snapshot for a snapshot in case snapshot chain is corrupted."})
public class SnapshotChainRepair
extends RepairTool {
    protected static final Logger LOG = LoggerFactory.getLogger(SnapshotChainRepair.class);
    @CommandLine.Mixin
    private BucketUri bucketUri;
    @CommandLine.Parameters(description={"Snapshot name to update"}, index="1")
    private String snapshotName;
    @CommandLine.Option(names={"--db"}, required=true, description={"Database File Path"})
    private String dbPath;
    @CommandLine.Option(names={"--global-previous", "--gp"}, required=true, description={"Global previous snapshotId to set for the given snapshot"})
    private UUID globalPreviousSnapshotId;
    @CommandLine.Option(names={"--path-previous", "--pp"}, required=true, description={"Path previous snapshotId to set for the given snapshot"})
    private UUID pathPreviousSnapshotId;

    @Override
    @Nonnull
    protected RepairTool.Component serviceToBeOffline() {
        return RepairTool.Component.OM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute() throws Exception {
        configOptions = new ManagedConfigOptions();
        dbOptions = new ManagedDBOptions();
        cfHandleList = new ArrayList<ColumnFamilyHandle>();
        cfDescList = new ArrayList<E>();
        try {
            db = ManagedRocksDB.openWithLatestOptions((ManagedConfigOptions)configOptions, (DBOptions)dbOptions, (String)this.dbPath, cfDescList, cfHandleList);
            snapshotInfoCfh = RocksDBUtils.getColumnFamilyHandle("snapshotInfoTable", cfHandleList);
            if (snapshotInfoCfh != null) ** GOTO lbl-1000
            this.error("%s is not in a column family in DB for the given path.", new Object[]{"snapshotInfoTable"});
            if (db != null) {
            }
            ** GOTO lbl29
            db.close();
            ** GOTO lbl29
        }
        catch (RocksDBException exception) {
            block30: {
                block28: {
                    block29: {
                        block27: {
                            block26: {
                                block25: {
                                    block24: {
                                        try {
                                            this.error("Failed to update the RocksDB for the given path: %s", new Object[]{this.dbPath});
                                            this.error("Make sure that Ozone entity (OM, SCM or DN) is not running for the give dbPath and current host.", new Object[0]);
                                            SnapshotChainRepair.LOG.error(exception.toString());
                                        }
                                        catch (Throwable var12_15) {
                                            IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{configOptions});
                                            IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{dbOptions});
                                            IOUtils.closeQuietly(cfHandleList);
                                            throw var12_15;
                                        }
lbl29:
                                        // 2 sources

                                        IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{configOptions});
                                        IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{dbOptions});
                                        IOUtils.closeQuietly(cfHandleList);
                                        return;
lbl-1000:
                                        // 1 sources

                                        {
                                            snapshotInfoTableKey = SnapshotInfo.getTableKey((String)this.bucketUri.getValue().getVolumeName(), (String)this.bucketUri.getValue().getBucketName(), (String)this.snapshotName);
                                            snapshotInfo = (SnapshotInfo)RocksDBUtils.getValue(db, snapshotInfoCfh, snapshotInfoTableKey, SnapshotInfo.getCodec());
                                            if (snapshotInfo != null) ** GOTO lbl-1000
                                            this.error("%s does not exist for given bucketUri: %s", new Object[]{this.snapshotName, "/" + this.bucketUri.getValue().getVolumeName() + "/" + this.bucketUri.getValue().getBucketName()});
                                            if (db == null) break block24;
                                        }
                                        db.close();
                                    }
                                    IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{configOptions});
                                    IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{dbOptions});
                                    IOUtils.closeQuietly(cfHandleList);
                                    return;
lbl-1000:
                                    // 1 sources

                                    {
                                        snapshotIdSet = this.getSnapshotIdSet(db, snapshotInfoCfh);
                                        if (!Objects.equals(snapshotInfo.getSnapshotId(), this.globalPreviousSnapshotId)) ** GOTO lbl-1000
                                        this.error("globalPreviousSnapshotId: '%s' is equal to given snapshot's ID: '%s'.", new Object[]{this.globalPreviousSnapshotId, snapshotInfo.getSnapshotId()});
                                        if (db == null) break block25;
                                    }
                                    db.close();
                                }
                                IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{configOptions});
                                IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{dbOptions});
                                IOUtils.closeQuietly(cfHandleList);
                                return;
lbl-1000:
                                // 1 sources

                                {
                                    if (!Objects.equals(snapshotInfo.getSnapshotId(), this.pathPreviousSnapshotId)) ** GOTO lbl-1000
                                    this.error("pathPreviousSnapshotId: '%s' is equal to given snapshot's ID: '%s'.", new Object[]{this.pathPreviousSnapshotId, snapshotInfo.getSnapshotId()});
                                    if (db == null) break block26;
                                }
                                db.close();
                            }
                            IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{configOptions});
                            IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{dbOptions});
                            IOUtils.closeQuietly(cfHandleList);
                            return;
lbl-1000:
                            // 1 sources

                            {
                                if (snapshotIdSet.contains(this.globalPreviousSnapshotId)) ** GOTO lbl-1000
                                this.error("globalPreviousSnapshotId: '%s' does not exist in snapshotInfoTable.", new Object[]{this.globalPreviousSnapshotId});
                                if (db == null) break block27;
                            }
                            db.close();
                        }
                        IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{configOptions});
                        IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{dbOptions});
                        IOUtils.closeQuietly(cfHandleList);
                        return;
lbl-1000:
                        // 1 sources

                        {
                            if (snapshotIdSet.contains(this.pathPreviousSnapshotId)) break block28;
                            this.error("pathPreviousSnapshotId: '%s' does not exist in snapshotInfoTable.", new Object[]{this.pathPreviousSnapshotId});
                            if (db == null) break block29;
                        }
                        db.close();
                    }
                    IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{configOptions});
                    IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{dbOptions});
                    IOUtils.closeQuietly(cfHandleList);
                    return;
                }
                ** try [egrp 13[TRYBLOCK] [6 : 566->670)] { 
lbl83:
                // 1 sources

                snapshotInfo.setGlobalPreviousSnapshotId(this.globalPreviousSnapshotId);
                snapshotInfo.setPathPreviousSnapshotId(this.pathPreviousSnapshotId);
                this.info("Updating SnapshotInfo to %s", new Object[]{snapshotInfo});
                snapshotInfoBytes = SnapshotInfo.getCodec().toPersistedFormat((Object)snapshotInfo);
                persistedFormat = StringCodec.get().toPersistedFormat(snapshotInfoTableKey);
                if (!this.isDryRun()) {
                    ((RocksDB)db.get()).put(snapshotInfoCfh, persistedFormat, snapshotInfoBytes);
                    this.info("Snapshot Info is updated to : %s", new Object[]{RocksDBUtils.getValue(db, snapshotInfoCfh, snapshotInfoTableKey, SnapshotInfo.getCodec())});
                }
                break block30;
lbl92:
                // 1 sources

                finally {
                    if (db != null) {
                        db.close();
                    }
                }
            }
            IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{configOptions});
            IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{dbOptions});
            IOUtils.closeQuietly(cfHandleList);
            return;
            IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{configOptions});
            IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{dbOptions});
            IOUtils.closeQuietly(cfHandleList);
            return;
        }
    }

    private Set<UUID> getSnapshotIdSet(ManagedRocksDB db, ColumnFamilyHandle snapshotInfoCfh) throws IOException {
        HashSet<UUID> snapshotIdSet = new HashSet<UUID>();
        try (ManagedRocksIterator iterator = new ManagedRocksIterator(((RocksDB)db.get()).newIterator(snapshotInfoCfh));){
            ((RocksIterator)iterator.get()).seekToFirst();
            while (((RocksIterator)iterator.get()).isValid()) {
                SnapshotInfo snapshotInfo = (SnapshotInfo)SnapshotInfo.getCodec().fromPersistedFormat(((RocksIterator)iterator.get()).value());
                snapshotIdSet.add(snapshotInfo.getSnapshotId());
                ((RocksIterator)iterator.get()).next();
            }
        }
        return snapshotIdSet;
    }
}

