/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.repair.datanode.schemaupgrade;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutFeature;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutVersionManager;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.ozone.container.common.DatanodeLayoutStorage;
import org.apache.hadoop.ozone.container.common.helpers.ContainerUtils;
import org.apache.hadoop.ozone.container.common.utils.StorageVolumeUtil;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.common.volume.MutableVolumeSet;
import org.apache.hadoop.ozone.container.common.volume.StorageVolume;
import org.apache.hadoop.ozone.container.metadata.DatanodeSchemaTwoDBDefinition;

final class UpgradeUtils {
    public static final Set<String> COLUMN_FAMILY_NAMES = Collections.unmodifiableSet(new DatanodeSchemaTwoDBDefinition("", (ConfigurationSource)new OzoneConfiguration()).getMap().keySet());
    public static final String BACKUP_CONTAINER_DATA_FILE_SUFFIX = ".backup";
    public static final String UPGRADE_COMPLETE_FILE_NAME = "upgrade.complete";
    public static final String UPGRADE_LOCK_FILE_NAME = "upgrade.lock";

    private UpgradeUtils() {
    }

    public static MutableVolumeSet getHddsVolumes(OzoneConfiguration conf, StorageVolume.VolumeType volumeType, String dnUuid) throws IOException {
        return new MutableVolumeSet(dnUuid, (ConfigurationSource)conf, null, volumeType, null);
    }

    public static DatanodeDetails getDatanodeDetails(OzoneConfiguration conf) throws IOException {
        String idFilePath = HddsServerUtil.getDatanodeIdFilePath((ConfigurationSource)conf);
        Preconditions.checkNotNull((Object)idFilePath);
        File idFile = new File(idFilePath);
        Preconditions.checkState((boolean)idFile.exists(), (Object)("Datanode id file: " + idFilePath + " not exists"));
        return ContainerUtils.readDatanodeDetailsFrom((File)idFile);
    }

    public static File getVolumeUpgradeCompleteFile(HddsVolume volume) {
        return new File(volume.getHddsRootDir(), UPGRADE_COMPLETE_FILE_NAME);
    }

    public static File getVolumeUpgradeLockFile(HddsVolume volume) {
        return new File(volume.getHddsRootDir(), UPGRADE_LOCK_FILE_NAME);
    }

    public static boolean createFile(File file) throws IOException {
        Date date = new Date();
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            writer.write(date.toString());
        }
        return file.exists();
    }

    public static Pair<HDDSLayoutFeature, HDDSLayoutFeature> getLayoutFeature(DatanodeDetails dnDetail, OzoneConfiguration conf) throws IOException {
        DatanodeLayoutStorage layoutStorage = new DatanodeLayoutStorage((ConfigurationSource)conf, dnDetail.getUuidString());
        HDDSLayoutVersionManager layoutVersionManager = new HDDSLayoutVersionManager(layoutStorage.getLayoutVersion());
        int metadataLayoutVersion = layoutVersionManager.getMetadataLayoutVersion();
        HDDSLayoutFeature metadataLayoutFeature = (HDDSLayoutFeature)layoutVersionManager.getFeature(metadataLayoutVersion);
        int softwareLayoutVersion = layoutVersionManager.getSoftwareLayoutVersion();
        HDDSLayoutFeature softwareLayoutFeature = (HDDSLayoutFeature)layoutVersionManager.getFeature(softwareLayoutVersion);
        return Pair.of((Object)softwareLayoutFeature, (Object)metadataLayoutFeature);
    }

    public static List<HddsVolume> getAllVolume(DatanodeDetails detail, OzoneConfiguration configuration) throws IOException {
        MutableVolumeSet dataVolumeSet = UpgradeUtils.getHddsVolumes(configuration, StorageVolume.VolumeType.DATA_VOLUME, detail.getUuidString());
        return StorageVolumeUtil.getHddsVolumesList((List)dataVolumeSet.getVolumesList());
    }

    public static boolean isAlreadyUpgraded(HddsVolume hddsVolume) {
        File migrateFile = UpgradeUtils.getVolumeUpgradeCompleteFile(hddsVolume);
        return migrateFile.exists();
    }
}

