/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug.replicas;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.XceiverClientManager;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.cli.ContainerOperationClient;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.storage.ContainerProtocolCalls;
import org.apache.hadoop.ozone.debug.replicas.BlockVerificationResult;
import org.apache.hadoop.ozone.debug.replicas.ReplicaVerifier;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;

public class ContainerStateVerifier
implements ReplicaVerifier {
    private static final String CHECK_TYPE = "containerState";
    private static final long DEFAULT_CONTAINER_CACHE_SIZE = 1000000L;
    private final ContainerOperationClient containerOperationClient;
    private final XceiverClientManager xceiverClientManager;
    private final Cache<Long, ContainerInfoToken> encodedTokenCache;
    private static final Set<ContainerProtos.ContainerDataProto.State> GOOD_REPLICA_STATES = EnumSet.of(ContainerProtos.ContainerDataProto.State.OPEN, ContainerProtos.ContainerDataProto.State.CLOSING, ContainerProtos.ContainerDataProto.State.QUASI_CLOSED, ContainerProtos.ContainerDataProto.State.CLOSED);
    private static final Set<HddsProtos.LifeCycleState> GOOD_CONTAINER_STATES = EnumSet.of(HddsProtos.LifeCycleState.OPEN, HddsProtos.LifeCycleState.CLOSING, HddsProtos.LifeCycleState.QUASI_CLOSED, HddsProtos.LifeCycleState.CLOSED);

    public ContainerStateVerifier(OzoneConfiguration conf, long containerCacheSize) throws IOException {
        this.containerOperationClient = new ContainerOperationClient(conf);
        this.xceiverClientManager = this.containerOperationClient.getXceiverClientManager();
        if (containerCacheSize < 1L) {
            System.err.println("Invalid cache size provided: " + containerCacheSize + ". Falling back to default: " + 1000000L);
            containerCacheSize = 1000000L;
        }
        this.encodedTokenCache = CacheBuilder.newBuilder().maximumSize(containerCacheSize).build();
    }

    @Override
    public String getType() {
        return CHECK_TYPE;
    }

    @Override
    public BlockVerificationResult verifyBlock(DatanodeDetails datanode, OmKeyLocationInfo keyLocation) {
        try {
            StringBuilder replicaCheckMsg = new StringBuilder().append("Replica state is ");
            boolean pass = false;
            ContainerInfoToken containerInfoToken = this.getContainerInfoToken(keyLocation.getContainerID());
            ContainerProtos.ContainerDataProto containerData = this.fetchContainerDataFromDatanode(datanode, keyLocation.getContainerID(), keyLocation, containerInfoToken);
            if (containerData == null) {
                return BlockVerificationResult.failIncomplete("No container data returned from DN.");
            }
            ContainerProtos.ContainerDataProto.State state = containerData.getState();
            replicaCheckMsg.append(state.name());
            if (this.areContainerAndReplicasInGoodState(state, containerInfoToken.getContainerState())) {
                pass = true;
            }
            replicaCheckMsg.append(", Container state in SCM is ").append(containerInfoToken.getContainerState());
            if (pass) {
                return BlockVerificationResult.pass();
            }
            return BlockVerificationResult.failCheck(replicaCheckMsg.toString());
        }
        catch (IOException e) {
            if (e.getMessage().contains("ContainerID") && e.getMessage().contains("does not exist")) {
                return BlockVerificationResult.failCheck(e.getMessage());
            }
            return BlockVerificationResult.failIncomplete(e.getMessage());
        }
    }

    private boolean areContainerAndReplicasInGoodState(ContainerProtos.ContainerDataProto.State replicaState, HddsProtos.LifeCycleState containerState) {
        return GOOD_REPLICA_STATES.contains(replicaState) && GOOD_CONTAINER_STATES.contains(containerState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ContainerProtos.ContainerDataProto fetchContainerDataFromDatanode(DatanodeDetails dn, long containerId, OmKeyLocationInfo keyLocation, ContainerInfoToken containerInfoToken) throws IOException {
        ContainerProtos.ReadContainerResponseProto response;
        block4: {
            XceiverClientSpi client = null;
            try {
                Pipeline pipeline = keyLocation.getPipeline().copyForReadFromNode(dn);
                String encodedToken = containerInfoToken.getEncodedToken();
                client = this.xceiverClientManager.acquireClientForReadData(pipeline);
                response = ContainerProtocolCalls.readContainer((XceiverClientSpi)client, (long)containerId, (String)encodedToken);
                if (client == null) break block4;
            }
            catch (Throwable throwable) {
                if (client != null) {
                    this.xceiverClientManager.releaseClient(client, false);
                }
                throw throwable;
            }
            this.xceiverClientManager.releaseClient(client, false);
        }
        if (!response.hasContainerData()) {
            return null;
        }
        return response.getContainerData();
    }

    private ContainerInfoToken getContainerInfoToken(long containerId) throws IOException {
        ContainerInfoToken cachedData = (ContainerInfoToken)this.encodedTokenCache.getIfPresent((Object)containerId);
        if (cachedData != null) {
            return cachedData;
        }
        ContainerInfo info = this.containerOperationClient.getContainer(containerId);
        String encodeToken = this.containerOperationClient.getEncodedContainerToken(containerId);
        cachedData = new ContainerInfoToken(info.getState(), encodeToken);
        this.encodedTokenCache.put((Object)containerId, (Object)cachedData);
        return cachedData;
    }

    private static class ContainerInfoToken {
        private HddsProtos.LifeCycleState state;
        private final String encodedToken;

        ContainerInfoToken(HddsProtos.LifeCycleState lifeState, String token) {
            this.state = lifeState;
            this.encodedToken = token;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ContainerInfoToken)) {
                return false;
            }
            ContainerInfoToken key = (ContainerInfoToken)o;
            return Objects.equals(this.state, key.state) && Objects.equals(this.encodedToken, key.encodedToken);
        }

        public int hashCode() {
            return Objects.hash(this.state, this.encodedToken);
        }

        public HddsProtos.LifeCycleState getContainerState() {
            return this.state;
        }

        public String getEncodedToken() {
            return this.encodedToken;
        }
    }
}

