/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.codahale.metrics.Timer;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.freon.BaseFreonGenerator;
import org.apache.hadoop.ozone.freon.FreonReplicationOptions;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OpenKeySession;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.security.UserGroupInformation;
import picocli.CommandLine;

@CommandLine.Command(name="omkg", aliases={"om-key-generator"}, description={"Create keys to the om metadata table."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class OmKeyGenerator
extends BaseFreonGenerator
implements Callable<Void> {
    @CommandLine.Option(names={"-v", "--volume"}, description={"Name of the volume which contains the test data. Will be created if missing."}, defaultValue="vol1")
    private String volumeName;
    @CommandLine.Option(names={"-b", "--bucket"}, description={"Name of the bucket which contains the test data. Will be created if missing."}, defaultValue="bucket1")
    private String bucketName;
    @CommandLine.Mixin
    private FreonReplicationOptions replication;
    @CommandLine.Option(names={"--om-service-id"}, description={"OM Service ID"})
    private String omServiceID = null;
    private OzoneManagerProtocol ozoneManagerClient;
    private Timer timer;
    private ReplicationConfig replicationConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        this.init();
        OzoneConfiguration conf = this.createOzoneConfiguration();
        this.replicationConfig = this.replication.fromParams((ConfigurationSource)conf).orElse(null);
        try (OzoneClient rpcClient = this.createOzoneClient(this.omServiceID, conf);){
            this.ensureVolumeAndBucketExist(rpcClient, this.volumeName, this.bucketName);
            this.ozoneManagerClient = this.createOmClient(conf, this.omServiceID);
            this.timer = this.getMetrics().timer("key-create");
            this.runTests(this::createKey);
        }
        finally {
            if (this.ozoneManagerClient != null) {
                this.ozoneManagerClient.close();
            }
        }
        return null;
    }

    private void createKey(long counter) throws Exception {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        String ownerName = ugi.getShortUserName();
        OmKeyArgs keyArgs = new OmKeyArgs.Builder().setBucketName(this.bucketName).setVolumeName(this.volumeName).setKeyName(this.generateObjectName(counter)).setReplicationConfig(this.replicationConfig).setLocationInfoList(new ArrayList()).setAcls(OzoneAclUtil.getAclList((UserGroupInformation)ugi, (IAccessAuthorizer.ACLType)IAccessAuthorizer.ACLType.ALL, (IAccessAuthorizer.ACLType)IAccessAuthorizer.ACLType.ALL)).setOwnerName(ownerName).build();
        this.timer.time(() -> {
            OpenKeySession openKeySession = this.ozoneManagerClient.openKey(keyArgs);
            this.ozoneManagerClient.commitKey(keyArgs, openKeySession.getId());
            return null;
        });
    }
}

