/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug.replicas.chunk;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.StandaloneReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.XceiverClientManager;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.cli.ContainerOperationClient;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.storage.ContainerProtocolCalls;
import org.apache.hadoop.hdds.server.JsonUtils;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.container.common.impl.ContainerLayoutVersion;
import org.apache.hadoop.ozone.debug.replicas.chunk.ChunkDetails;
import org.apache.hadoop.ozone.debug.replicas.chunk.ChunkType;
import org.apache.hadoop.ozone.debug.replicas.chunk.ContainerChunkInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.keys.KeyHandler;
import org.apache.hadoop.security.token.Token;
import picocli.CommandLine;

@CommandLine.Command(name="chunk-info", description={"Returns chunk location information about an existing key"})
public class ChunkKeyHandler
extends KeyHandler {
    private String getChunkLocationPath(String containerLocation) {
        return containerLocation + File.separator + "chunks";
    }

    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        try (ContainerOperationClient containerOperationClient = new ContainerOperationClient(this.getOzoneConf());
             XceiverClientManager xceiverClientManager = containerOperationClient.getXceiverClientManager();){
            OzoneManagerProtocol ozoneManagerClient = client.getObjectStore().getClientProxy().getOzoneManagerClient();
            address.ensureKeyAddress();
            ObjectNode result = JsonUtils.createObjectNode(null);
            String volumeName = address.getVolumeName();
            String bucketName = address.getBucketName();
            String keyName = address.getKeyName();
            ArrayList<ChunkDetails> chunkDetailsList = new ArrayList<ChunkDetails>();
            HashSet<String> chunkPaths = new HashSet<String>();
            OmKeyArgs keyArgs = new OmKeyArgs.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(keyName).build();
            OmKeyInfo keyInfo = ozoneManagerClient.lookupKey(keyArgs);
            List locationInfos = keyInfo.getLatestVersionLocations().getBlocksLatestVersionOnly();
            if (locationInfos.isEmpty()) {
                System.out.println("No Key Locations Found");
                return;
            }
            ContainerLayoutVersion containerLayoutVersion = ContainerLayoutVersion.getConfiguredVersion((ConfigurationSource)this.getConf());
            ArrayNode responseArrayList = JsonUtils.createArrayNode();
            for (OmKeyLocationInfo keyLocation : locationInfos) {
                ContainerChunkInfo containerChunkInfoVerbose = new ContainerChunkInfo();
                ContainerChunkInfo containerChunkInfo = new ContainerChunkInfo();
                long containerId = keyLocation.getContainerID();
                chunkPaths.clear();
                Pipeline keyPipeline = keyLocation.getPipeline();
                boolean isECKey = keyPipeline.getReplicationConfig().getReplicationType() == HddsProtos.ReplicationType.EC;
                Pipeline pipeline = !isECKey && keyPipeline.getType() != HddsProtos.ReplicationType.STAND_ALONE ? Pipeline.newBuilder((Pipeline)keyPipeline).setReplicationConfig((ReplicationConfig)StandaloneReplicationConfig.getInstance((HddsProtos.ReplicationFactor)HddsProtos.ReplicationFactor.ONE)).build() : keyPipeline;
                XceiverClientSpi xceiverClient = xceiverClientManager.acquireClientForReadData(pipeline);
                try {
                    ContainerProtos.DatanodeBlockID datanodeBlockID = keyLocation.getBlockID().getDatanodeBlockIDProtobuf();
                    HashMap responses = ContainerProtocolCalls.getBlockFromAllNodes((XceiverClientSpi)xceiverClient, (ContainerProtos.DatanodeBlockID)keyLocation.getBlockID().getDatanodeBlockIDProtobuf(), (Token)keyLocation.getToken());
                    Map readContainerResponses = containerOperationClient.readContainerFromAllNodes(keyLocation.getContainerID(), pipeline);
                    ArrayNode responseFromAllNodes = JsonUtils.createArrayNode();
                    for (Map.Entry entry : responses.entrySet()) {
                        chunkPaths.clear();
                        ObjectNode jsonObj = JsonUtils.createObjectNode(null);
                        if (entry.getValue() == null) {
                            LOG.error("Cant execute getBlock on this node");
                            continue;
                        }
                        List tempchunks = ((ContainerProtos.GetBlockResponseProto)entry.getValue()).getBlockData().getChunksList();
                        ContainerProtos.ContainerDataProto containerData = ((ContainerProtos.ReadContainerResponseProto)readContainerResponses.get(entry.getKey())).getContainerData();
                        for (ContainerProtos.ChunkInfo chunkInfo : tempchunks) {
                            String fileName = containerLayoutVersion.getChunkFile(new File(this.getChunkLocationPath(containerData.getContainerPath())), keyLocation.getBlockID(), chunkInfo.getChunkName()).toString();
                            chunkPaths.add(fileName);
                            ChunkDetails chunkDetails = new ChunkDetails();
                            chunkDetails.setChunkName(fileName);
                            chunkDetails.setChunkOffset(chunkInfo.getOffset());
                            chunkDetailsList.add(chunkDetails);
                        }
                        containerChunkInfoVerbose.setContainerPath(containerData.getContainerPath());
                        containerChunkInfoVerbose.setPipeline(keyPipeline);
                        containerChunkInfoVerbose.setChunkInfos(chunkDetailsList);
                        containerChunkInfo.setFiles(chunkPaths);
                        containerChunkInfo.setPipelineID(keyPipeline.getId().getId());
                        if (isECKey) {
                            ChunkType blockChunksType = this.isECParityBlock(keyPipeline, (DatanodeDetails)entry.getKey()) ? ChunkType.PARITY : ChunkType.DATA;
                            containerChunkInfoVerbose.setChunkType(blockChunksType);
                            containerChunkInfo.setChunkType(blockChunksType);
                        }
                        if (this.isVerbose()) {
                            jsonObj.set("Locations", (JsonNode)JsonUtils.createObjectNode((Object)containerChunkInfoVerbose));
                        } else {
                            jsonObj.set("Locations", (JsonNode)JsonUtils.createObjectNode((Object)containerChunkInfo));
                        }
                        jsonObj.put("Datanode-HostName", ((DatanodeDetails)entry.getKey()).getHostName());
                        jsonObj.put("Datanode-IP", ((DatanodeDetails)entry.getKey()).getIpAddress());
                        jsonObj.put("Container-ID", containerId);
                        jsonObj.put("Block-ID", keyLocation.getLocalID());
                        responseFromAllNodes.add((JsonNode)jsonObj);
                    }
                    responseArrayList.add((JsonNode)responseFromAllNodes);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    xceiverClientManager.releaseClientForReadData(xceiverClient, false);
                }
            }
            result.set("KeyLocations", (JsonNode)responseArrayList);
            String prettyJson = JsonUtils.toJsonStringWithDefaultPrettyPrinter((Object)result);
            System.out.println(prettyJson);
        }
    }

    private boolean isECParityBlock(Pipeline pipeline, DatanodeDetails dn) {
        return pipeline.getReplicaIndex(dn) > ((ECReplicationConfig)pipeline.getReplicationConfig()).getData();
    }
}

