/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.admin.om;

import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.server.JsonUtils;
import org.apache.hadoop.ozone.OzoneManagerVersion;
import org.apache.hadoop.ozone.admin.om.OMAdmin;
import org.apache.hadoop.ozone.client.rpc.RpcClient;
import org.apache.hadoop.ozone.om.helpers.ListOpenFilesResult;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OpenKeySession;
import org.apache.hadoop.ozone.om.helpers.ServiceInfoEx;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolClientSideTranslatorPB;
import picocli.CommandLine;

@CommandLine.Command(name="list-open-files", aliases={"list-open-keys", "lof", "lok"}, description={"Lists open files (keys) in Ozone Manager."}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class ListOpenFilesSubCommand
implements Callable<Void> {
    @CommandLine.ParentCommand
    private OMAdmin parent;
    @CommandLine.Option(names={"--service-id", "--om-service-id"}, description={"Ozone Manager Service ID"}, required=false)
    private String omServiceId;
    @CommandLine.Option(names={"--service-host"}, description={"Ozone Manager Host. If OM HA is enabled, use --service-id instead. If you must use --service-host with OM HA, this must point directly to the leader OM. This option is required when --service-id is not provided or when HA is not enabled."})
    private String omHost;
    @CommandLine.Option(names={"--json"}, defaultValue="false", description={"Format output as JSON"})
    private boolean json;
    @CommandLine.Option(names={"--show-deleted"}, defaultValue="false", description={"Whether to show deleted open keys"})
    private boolean showDeleted;
    @CommandLine.Option(names={"--show-overwritten"}, defaultValue="false", description={"Whether to show overwritten open keys"})
    private boolean showOverwritten;
    @CommandLine.Option(names={"-p", "--prefix"}, description={"Filter results by the specified path on the server side."}, defaultValue="/")
    private String pathPrefix;
    @CommandLine.Option(names={"-l", "--length"}, description={"Maximum number of items to list"}, defaultValue="100")
    private int limit;
    @CommandLine.Option(names={"-s", "--start"}, description={"The item to start the listing from.\ni.e. continuation token. This will be excluded from the result."}, defaultValue="")
    private String startItem;

    @Override
    public Void call() throws Exception {
        if (StringUtils.isEmpty((CharSequence)this.omServiceId) && StringUtils.isEmpty((CharSequence)this.omHost)) {
            System.err.println("Error: Please specify --service-id or --service-host");
            return null;
        }
        OzoneManagerProtocolClientSideTranslatorPB ozoneManagerClient = this.parent.createOmClient(this.omServiceId, this.omHost, false);
        ServiceInfoEx serviceInfoEx = ozoneManagerClient.getServiceInfo();
        OzoneManagerVersion omVersion = RpcClient.getOmVersion((ServiceInfoEx)serviceInfoEx);
        if (omVersion.compareTo((Enum)OzoneManagerVersion.HBASE_SUPPORT) < 0) {
            System.err.println("Error: This command requires OzoneManager version " + OzoneManagerVersion.HBASE_SUPPORT.name() + " or later.");
            return null;
        }
        ListOpenFilesResult res = ozoneManagerClient.listOpenFiles(this.pathPrefix, this.limit, this.startItem);
        if (!this.showDeleted) {
            res.getOpenKeys().removeIf(o -> o.getKeyInfo().getMetadata().containsKey("deletedHsyncKey"));
        }
        if (!this.showOverwritten) {
            res.getOpenKeys().removeIf(o -> o.getKeyInfo().getMetadata().containsKey("overwrittenHsyncKey"));
        }
        if (this.json) {
            this.printOpenKeysListAsJson(res);
        } else {
            this.printOpenKeysList(res);
        }
        return null;
    }

    private void printOpenKeysListAsJson(ListOpenFilesResult res) throws IOException {
        System.out.println(JsonUtils.toJsonStringWithDefaultPrettyPrinter((Object)res));
    }

    private void printOpenKeysList(ListOpenFilesResult res) {
        List openFileList = res.getOpenKeys();
        String msg = res.getTotalOpenKeyCount() + " total open files (est.). Showing " + openFileList.size() + " open files (limit " + this.limit + ") under path prefix:\n  " + this.pathPrefix;
        if (this.startItem != null && !this.startItem.isEmpty()) {
            msg = msg + "\nafter continuation token:\n  " + this.startItem;
        }
        msg = msg + "\n\nClient ID\t\t\tCreation time\t\tHsync'ed\t";
        msg = msg + (this.showDeleted ? "Deleted\t" : "");
        msg = msg + (this.showOverwritten ? "Overwritten\t" : "");
        msg = msg + "Open File Path";
        System.out.println(msg);
        for (OpenKeySession e : openFileList) {
            long clientId = e.getId();
            OmKeyInfo omKeyInfo = e.getKeyInfo();
            String line = clientId + "\t" + Instant.ofEpochMilli(omKeyInfo.getCreationTime()) + "\t";
            if (omKeyInfo.isHsync()) {
                String hsyncClientIdStr = (String)omKeyInfo.getMetadata().get("hsyncClientId");
                long hsyncClientId = Long.parseLong(hsyncClientIdStr);
                line = clientId == hsyncClientId ? line + "Yes\t\t" : line + "Yes w/ cid " + hsyncClientIdStr + "\t";
                if (this.showDeleted) {
                    line = omKeyInfo.getMetadata().containsKey("deletedHsyncKey") ? line + "Yes\t\t" : line + "No\t\t";
                }
                if (this.showOverwritten) {
                    line = omKeyInfo.getMetadata().containsKey("overwrittenHsyncKey") ? line + "Yes\t" : line + "No\t";
                }
            } else {
                line = line + (this.showDeleted ? "No\t\tNo\t\t" : "No\t\t");
                line = line + (this.showOverwritten ? "No\t" : "");
            }
            line = line + this.getFullPathFromKeyInfo(omKeyInfo);
            System.out.println(line);
        }
        if (res.hasMore()) {
            String nextBatchCmd = this.getCmdForNextBatch(res.getContinuationToken());
            System.out.println("\nTo get the next batch of open keys, run:\n  " + nextBatchCmd);
        } else {
            System.out.println("\nReached the end of the list.");
        }
    }

    private String getCmdForNextBatch(String lastElementFullPath) {
        String nextBatchCmd = "ozone admin om lof";
        if (this.omServiceId != null && !this.omServiceId.isEmpty()) {
            nextBatchCmd = nextBatchCmd + " -id=" + this.omServiceId;
        }
        if (this.omHost != null && !this.omHost.isEmpty()) {
            nextBatchCmd = nextBatchCmd + " -host=" + this.omHost;
        }
        if (this.json) {
            nextBatchCmd = nextBatchCmd + " --json";
        }
        nextBatchCmd = nextBatchCmd + " --length=" + this.limit;
        if (this.pathPrefix != null && !this.pathPrefix.isEmpty()) {
            nextBatchCmd = nextBatchCmd + " --prefix=" + this.pathPrefix;
        }
        nextBatchCmd = nextBatchCmd + " --start=" + lastElementFullPath;
        return nextBatchCmd;
    }

    private String getFullPathFromKeyInfo(OmKeyInfo oki) {
        return "/" + oki.getVolumeName() + "/" + oki.getBucketName() + "/" + oki.getPath();
    }
}

