/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3;

import jakarta.annotation.Priority;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@PreMatching
@Priority(value=200)
public class ClientIpFilter
implements ContainerRequestFilter {
    public static final int PRIORITY = 200;
    public static final String CLIENT_IP_HEADER = "client_ip";
    private static final Logger LOG = LoggerFactory.getLogger(ClientIpFilter.class);
    @Context
    private HttpServletRequest httpServletRequest;

    public void filter(ContainerRequestContext request) throws IOException {
        String clientIp = this.httpServletRequest.getHeader("x-real-ip");
        if (clientIp == null || clientIp.isEmpty()) {
            String ipForwarded = this.httpServletRequest.getHeader("x-forwarded-for");
            String[] ips = ipForwarded == null ? null : ipForwarded.split(",");
            clientIp = ips == null || ips.length == 0 ? null : ips[0];
            clientIp = clientIp == null || clientIp.isEmpty() ? this.httpServletRequest.getRemoteAddr() : clientIp;
        }
        LOG.trace("Real Ip[{}]", (Object)clientIp);
        request.getHeaders().putSingle((Object)CLIENT_IP_HEADER, (Object)clientIp);
    }
}

