/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.signature;

import com.google.common.annotations.VisibleForTesting;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.ozone.s3.signature.Credential;
import org.apache.hadoop.ozone.s3.signature.MalformedResourceException;
import org.apache.hadoop.ozone.s3.signature.SignatureInfo;
import org.apache.hadoop.ozone.s3.signature.SignatureParser;
import org.apache.hadoop.ozone.s3.signature.SignatureProcessor;

public class AuthorizationV4HeaderParser
implements SignatureParser {
    private static final String CREDENTIAL = "Credential=";
    private static final String SIGNEDHEADERS = "SignedHeaders=";
    private static final String SIGNATURE = "Signature=";
    private static final String AWS_REQUEST = "aws4_request";
    private String authHeader;
    private String dateHeader;

    public AuthorizationV4HeaderParser(String authHeader, String dateHeader) {
        this.authHeader = authHeader;
        this.dateHeader = dateHeader;
    }

    @Override
    public SignatureInfo parseSignature() throws MalformedResourceException {
        if (this.authHeader == null || !this.authHeader.startsWith("AWS4")) {
            return null;
        }
        int firstSep = this.authHeader.indexOf(32);
        if (firstSep < 0) {
            throw new MalformedResourceException(this.authHeader);
        }
        String[] split = this.authHeader.substring(firstSep + 1).trim().split(", *");
        if (split.length != 3) {
            throw new MalformedResourceException(this.authHeader);
        }
        String algorithm = this.parseAlgorithm(this.authHeader.substring(0, firstSep));
        Credential credentialObj = this.parseCredentials(split[0]);
        String signedHeaders = this.parseSignedHeaders(split[1]);
        String signature = this.parseSignature(split[2]);
        return new SignatureInfo.Builder(SignatureInfo.Version.V4).setDate(credentialObj.getDate()).setDateTime(this.dateHeader).setAwsAccessId(credentialObj.getAccessKeyID()).setSignature(signature).setSignedHeaders(signedHeaders).setCredentialScope(credentialObj.createScope()).setAlgorithm(algorithm).setSignPayload(true).build();
    }

    private String parseSignedHeaders(String signedHeadersStr) throws MalformedResourceException {
        if (StringUtils.isNotEmpty((CharSequence)signedHeadersStr) && signedHeadersStr.startsWith(SIGNEDHEADERS)) {
            String parsedSignedHeaders = signedHeadersStr.substring(SIGNEDHEADERS.length());
            Collection signedHeaders = org.apache.hadoop.util.StringUtils.getStringCollection((String)parsedSignedHeaders, (String)";");
            if (signedHeaders.isEmpty()) {
                throw new MalformedResourceException("No signed headers found.", this.authHeader);
            }
            return parsedSignedHeaders;
        }
        throw new MalformedResourceException("No signed headers found.", this.authHeader);
    }

    private String parseSignature(String signature) throws MalformedResourceException {
        if (signature.startsWith(SIGNATURE)) {
            String parsedSignature = signature.substring(SIGNATURE.length());
            if (StringUtils.isEmpty((CharSequence)parsedSignature)) {
                throw new MalformedResourceException("Signature can't be empty: " + signature, this.authHeader);
            }
            try {
                Hex.decodeHex((String)parsedSignature);
            }
            catch (DecoderException e) {
                throw new MalformedResourceException("Signature:" + signature + " should be in hexa-decimal encoding.", this.authHeader);
            }
            return parsedSignature;
        }
        throw new MalformedResourceException("No signature found: " + signature, this.authHeader);
    }

    private Credential parseCredentials(String credential) throws MalformedResourceException {
        Credential credentialObj = null;
        if (!StringUtils.isNotEmpty((CharSequence)credential) || !credential.startsWith(CREDENTIAL)) {
            throw new MalformedResourceException(this.authHeader);
        }
        credential = credential.substring(CREDENTIAL.length());
        credentialObj = new Credential(credential);
        if (credentialObj.getAccessKeyID().isEmpty()) {
            throw new MalformedResourceException("AWS access id is empty. credential: " + credential, this.authHeader);
        }
        if (credentialObj.getAwsRegion().isEmpty()) {
            throw new MalformedResourceException("AWS region is empty. credential: " + credential, this.authHeader);
        }
        if (credentialObj.getAwsRequest().isEmpty() || !credentialObj.getAwsRequest().equals(AWS_REQUEST)) {
            throw new MalformedResourceException("AWS request is empty or invalid. credential:" + credential, this.authHeader);
        }
        if (credentialObj.getAwsService().isEmpty()) {
            throw new MalformedResourceException("AWS service is empty. credential:" + credential, this.authHeader);
        }
        if (!credentialObj.getDate().isEmpty()) {
            try {
                this.validateDateRange(credentialObj);
            }
            catch (DateTimeParseException ex) {
                throw new MalformedResourceException("AWS date format is invalid. credential:" + credential, this.authHeader);
            }
        } else {
            throw new MalformedResourceException("AWS date is empty. credential:{}" + credential, this.authHeader);
        }
        return credentialObj;
    }

    @VisibleForTesting
    public void validateDateRange(Credential credentialObj) throws MalformedResourceException, DateTimeParseException {
        LocalDate now;
        LocalDate date = LocalDate.parse(credentialObj.getDate(), SignatureProcessor.DATE_FORMATTER);
        if (date.isBefore((now = LocalDate.now()).minus(1L, ChronoUnit.DAYS)) || date.isAfter(now.plus(1L, ChronoUnit.DAYS))) {
            throw new MalformedResourceException("AWS date not in valid range. Date: " + date + " should not be older than 1 day(i.e yesterday) and greater than 1 day(i.e tomorrow).", this.authHeader);
        }
    }

    private String parseAlgorithm(String algorithm) throws MalformedResourceException {
        if (StringUtils.isEmpty((CharSequence)algorithm) || !algorithm.equals("AWS4-HMAC-SHA256")) {
            throw new MalformedResourceException("Unexpected hash algorithm. Algo:" + algorithm, this.authHeader);
        }
        return algorithm;
    }
}

