/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3;

import java.io.IOException;
import javax.annotation.PreDestroy;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.s3.OzoneClientCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class OzoneClientProducer {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneClientProducer.class);
    private OzoneClient client;
    @Inject
    private OzoneConfiguration ozoneConfiguration;
    @Context
    private ContainerRequestContext context;

    @Produces
    public synchronized OzoneClient createClient() throws WebApplicationException, IOException {
        this.ozoneConfiguration.set("ozone.om.group.rights", "NONE");
        this.client = this.getClient(this.ozoneConfiguration);
        return this.client;
    }

    @PreDestroy
    public void destroy() throws IOException {
        this.client.getObjectStore().getClientProxy().clearThreadLocalS3Auth();
    }

    private OzoneClient getClient(OzoneConfiguration config) throws IOException {
        OzoneClient ozoneClient = null;
        try {
            ozoneClient = OzoneClientCache.getOzoneClientInstance(this.ozoneConfiguration);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error during Client Creation: ", (Throwable)e);
            }
            throw e;
        }
        return ozoneClient;
    }

    public synchronized void setOzoneConfiguration(OzoneConfiguration config) {
        this.ozoneConfiguration = config;
    }
}

