/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.recon.schema;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import org.jooq.SelectField;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SqlDbUtils {
    public static final String DERBY_DRIVER_CLASS = "org.apache.derby.jdbc.EmbeddedDriver";
    public static final String SQLITE_DRIVER_CLASS = "org.sqlite.JDBC";
    public static final String DERBY_DISABLE_LOG_METHOD = SqlDbUtils.class.getName() + ".disableDerbyLogFile";
    private static final Logger LOG = LoggerFactory.getLogger(SqlDbUtils.class);
    public static final BiPredicate<Connection, String> TABLE_EXISTS_CHECK = (conn, tableName) -> {
        try {
            DSL.using((Connection)conn).select((SelectField)DSL.count()).from(tableName).execute();
        }
        catch (DataAccessException ex) {
            LOG.debug(ex.getMessage());
            return false;
        }
        LOG.info("{} table already exists, skipping creation.", tableName);
        return true;
    };

    private SqlDbUtils() {
    }

    public static void createNewDerbyDatabase(String jdbcUrl, String schemaName) throws ClassNotFoundException, SQLException {
        System.setProperty("derby.stream.error.method", DERBY_DISABLE_LOG_METHOD);
        Class.forName(DERBY_DRIVER_CLASS);
        try (Connection connection = DriverManager.getConnection(jdbcUrl + ";user=" + schemaName + ";create=true");){
            LOG.info("Created derby database at {}.", (Object)jdbcUrl);
        }
    }

    public static OutputStream disableDerbyLogFile() {
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        };
    }

    public static List<String> listAllTables(Connection connection) throws SQLException {
        ArrayList<String> tableNames = new ArrayList<String>();
        try (ResultSet resultSet = connection.getMetaData().getTables(null, null, null, new String[]{"TABLE"});){
            while (resultSet.next()) {
                String tableName = resultSet.getString("TABLE_NAME");
                tableNames.add(tableName);
            }
        }
        LOG.debug("Found {} user-defined tables in the database: {}", (Object)tableNames.size(), tableNames);
        return tableNames;
    }
}

