/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.tasks;

import com.google.protobuf.MessageLite;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.DelegatedCodec;
import org.apache.hadoop.hdds.utils.db.Proto2Codec;
import org.apache.hadoop.ozone.storage.proto.OzoneManagerStorageProtos;

public class FileSizeCountKey {
    private static final Codec<FileSizeCountKey> CODEC = new DelegatedCodec(Proto2Codec.get((MessageLite)OzoneManagerStorageProtos.FileSizeCountKeyProto.getDefaultInstance()), FileSizeCountKey::fromProto, FileSizeCountKey::toProto, FileSizeCountKey.class);
    private final String volume;
    private final String bucket;
    private final Long fileSizeUpperBound;

    public FileSizeCountKey(String volume, String bucket, Long fileSizeUpperBound) {
        this.volume = volume;
        this.bucket = bucket;
        this.fileSizeUpperBound = fileSizeUpperBound;
    }

    public static Codec<FileSizeCountKey> getCodec() {
        return CODEC;
    }

    public String getVolume() {
        return this.volume;
    }

    public String getBucket() {
        return this.bucket;
    }

    public Long getFileSizeUpperBound() {
        return this.fileSizeUpperBound;
    }

    public OzoneManagerStorageProtos.FileSizeCountKeyProto toProto() {
        return OzoneManagerStorageProtos.FileSizeCountKeyProto.newBuilder().setVolume(this.volume).setBucket(this.bucket).setFileSizeUpperBound(this.fileSizeUpperBound.longValue()).build();
    }

    public static FileSizeCountKey fromProto(OzoneManagerStorageProtos.FileSizeCountKeyProto proto) {
        return new FileSizeCountKey(proto.getVolume(), proto.getBucket(), proto.getFileSizeUpperBound());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSizeCountKey that = (FileSizeCountKey)o;
        if (!this.volume.equals(that.volume)) {
            return false;
        }
        if (!this.bucket.equals(that.bucket)) {
            return false;
        }
        return this.fileSizeUpperBound.equals(that.fileSizeUpperBound);
    }

    public int hashCode() {
        int result = this.volume.hashCode();
        result = 31 * result + this.bucket.hashCode();
        result = 31 * result + this.fileSizeUpperBound.hashCode();
        return result;
    }

    public String toString() {
        return "FileSizeCountKey{volume='" + this.volume + '\'' + ", bucket='" + this.bucket + '\'' + ", fileSizeUpperBound=" + this.fileSizeUpperBound + '}';
    }
}

