/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.metrics;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableRate;

@InterfaceAudience.Private
@Metrics(about="Recon Task Metrics", context="ozone")
public final class ReconTaskMetrics
implements MetricsSource {
    private static final String SOURCE_NAME = ReconTaskMetrics.class.getSimpleName();
    private final MetricsRegistry registry = new MetricsRegistry(SOURCE_NAME);
    @Metric(about="Total number of unique tasks tracked")
    private MutableCounterLong numTasksTracked;
    private final ConcurrentMap<String, MutableCounterLong> taskDeltaProcessingSuccess = new ConcurrentHashMap<String, MutableCounterLong>();
    private final ConcurrentMap<String, MutableCounterLong> taskDeltaProcessingFailures = new ConcurrentHashMap<String, MutableCounterLong>();
    private final ConcurrentMap<String, MutableRate> taskDeltaProcessingDuration = new ConcurrentHashMap<String, MutableRate>();
    private final ConcurrentMap<String, MutableCounterLong> taskReprocessFailures = new ConcurrentHashMap<String, MutableCounterLong>();
    private final ConcurrentMap<String, MutableRate> taskReprocessDuration = new ConcurrentHashMap<String, MutableRate>();

    private ReconTaskMetrics() {
    }

    public static ReconTaskMetrics create() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (ReconTaskMetrics)ms.register(SOURCE_NAME, "Recon Task Metrics", (Object)new ReconTaskMetrics());
    }

    public void unRegister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }

    public void incrTaskDeltaProcessingSuccess(String taskName) {
        this.taskDeltaProcessingSuccess.computeIfAbsent(taskName, k -> this.registry.newCounter("TaskDeltaProcessingSuccess_" + this.sanitizeTaskName(taskName), "Success count for task " + taskName, 0L)).incr();
    }

    public void incrTaskDeltaProcessingFailures(String taskName) {
        this.taskDeltaProcessingFailures.computeIfAbsent(taskName, k -> this.registry.newCounter("TaskDeltaProcessingFailures_" + this.sanitizeTaskName(taskName), "Failure count for task " + taskName, 0L)).incr();
    }

    public void updateTaskDeltaProcessingDuration(String taskName, long duration) {
        this.taskDeltaProcessingDuration.computeIfAbsent(taskName, k -> this.registry.newRate("TaskDeltaProcessingDuration_" + this.sanitizeTaskName(taskName), "Processing duration for task " + taskName)).add(duration);
    }

    public void incrTaskReprocessFailures(String taskName) {
        this.taskReprocessFailures.computeIfAbsent(taskName, k -> this.registry.newCounter("TaskReprocessFailures_" + this.sanitizeTaskName(taskName), "Reprocess failure count for task " + taskName, 0L)).incr();
    }

    public void updateTaskReprocessDuration(String taskName, long duration) {
        this.taskReprocessDuration.computeIfAbsent(taskName, k -> this.registry.newRate("TaskReprocessDuration_" + this.sanitizeTaskName(taskName), "Reprocess duration for task " + taskName)).add(duration);
    }

    private String sanitizeTaskName(String taskName) {
        return taskName.replaceAll("[^a-zA-Z0-9]", "_");
    }

    public long getTaskDeltaProcessingSuccess(String taskName) {
        MutableCounterLong counter = (MutableCounterLong)this.taskDeltaProcessingSuccess.get(taskName);
        return counter != null ? counter.value() : 0L;
    }

    public long getTaskDeltaProcessingFailures(String taskName) {
        MutableCounterLong counter = (MutableCounterLong)this.taskDeltaProcessingFailures.get(taskName);
        return counter != null ? counter.value() : 0L;
    }

    public MutableRate getTaskDeltaProcessingDuration(String taskName) {
        return (MutableRate)this.taskDeltaProcessingDuration.get(taskName);
    }

    public long getTaskReprocessFailures(String taskName) {
        MutableCounterLong counter = (MutableCounterLong)this.taskReprocessFailures.get(taskName);
        return counter != null ? counter.value() : 0L;
    }

    public MutableRate getTaskReprocessDuration(String taskName) {
        return (MutableRate)this.taskReprocessDuration.get(taskName);
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder recordBuilder = collector.addRecord(SOURCE_NAME);
        this.numTasksTracked.snapshot(recordBuilder, all);
        this.taskDeltaProcessingSuccess.values().forEach(metric -> metric.snapshot(recordBuilder, all));
        this.taskDeltaProcessingFailures.values().forEach(metric -> metric.snapshot(recordBuilder, all));
        this.taskDeltaProcessingDuration.values().forEach(metric -> metric.snapshot(recordBuilder, all));
        this.taskReprocessFailures.values().forEach(metric -> metric.snapshot(recordBuilder, all));
        this.taskReprocessDuration.values().forEach(metric -> metric.snapshot(recordBuilder, all));
    }
}

